/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.profiler.Logging;
import org.gradle.profiler.TeeOutputStream;

public class CommandExec {
    private final File directory;

    public CommandExec() {
        this.directory = null;
    }

    protected CommandExec(File directory) {
        this.directory = directory;
    }

    public CommandExec inDir(File directory) {
        return new CommandExec(directory);
    }

    public void run(Collection<String> commandLine) {
        this.start(commandLine).waitForSuccess();
    }

    public RunHandle start(Collection<String> commandLine) {
        return this.start(commandLine.toArray(new String[commandLine.size()]));
    }

    public void run(String ... commandLine) {
        this.start(commandLine).waitForSuccess();
    }

    public RunHandle start(String ... commandLine) {
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        return this.start(processBuilder);
    }

    public String runAndCollectOutput(List<String> commandLine) {
        return this.runAndCollectOutput(commandLine.toArray(new String[commandLine.size()]));
    }

    public String runAndCollectOutput(String ... commandLine) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.start(new ProcessBuilder(commandLine), outputStream, outputStream::toString, null).waitForSuccess();
        }
        catch (RuntimeException e) {
            System.out.print(new String(outputStream.toByteArray()));
            throw e;
        }
        return new String(outputStream.toByteArray());
    }

    public void runAndCollectOutput(File outputFile, Collection<String> commandLine) {
        this.runAndCollectOutput(outputFile, commandLine.toArray(new String[0]));
    }

    public void runAndCollectOutput(File outputFile, String ... commandLine) {
        OutputStream outputStream = this.createFileOutputStream(outputFile);
        this.start(new ProcessBuilder(commandLine), outputStream, () -> "See build log " + outputFile + " for details", null).waitForSuccess();
    }

    private OutputStream createFileOutputStream(File outputFile) {
        try {
            return new FileOutputStream(outputFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void runAndCollectOutput(File outputFile, ProcessBuilder processBuilder) {
        OutputStream outputStream = this.createFileOutputStream(outputFile);
        this.start(processBuilder, outputStream, () -> "See build log " + outputFile + " for details", null).waitForSuccess();
    }

    public void run(ProcessBuilder processBuilder) {
        this.start(processBuilder).waitForSuccess();
    }

    public RunHandle start(ProcessBuilder processBuilder) {
        PrintStream outputStream = Logging.detailed();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        return this.start(processBuilder, new TeeOutputStream(outputStream, baos), baos::toString, null);
    }

    private RunHandle start(ProcessBuilder processBuilder, OutputStream outputStream, Supplier<String> diagnosticOutput, @Nullable InputStream inputStream) {
        if (this.directory != null) {
            processBuilder.directory(this.directory);
        }
        String command = processBuilder.command().get(0);
        Logging.detailed().println("Running command " + String.join((CharSequence)" ", processBuilder.command()));
        try {
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            ExecutorService executor = Executors.newFixedThreadPool(3);
            executor.execute(() -> {
                byte[] buffer = new byte[4096];
                while (!this.readStream(process.getInputStream(), outputStream, command, buffer)) {
                }
            });
            executor.execute(() -> {
                byte[] buffer = new byte[4096];
                while (!this.readStream(process.getErrorStream(), outputStream, command, buffer)) {
                }
            });
            if (inputStream != null) {
                executor.execute(() -> {
                    byte[] buffer = new byte[4096];
                    OutputStream output = process.getOutputStream();
                    try {
                        int read;
                        do {
                            read = inputStream.read(buffer);
                            output.write(buffer);
                        } while (read != -1);
                        output.flush();
                        output.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not write input", e);
                    }
                });
            }
            return new RunHandle(processBuilder, process, diagnosticOutput, executor);
        }
        catch (IOException e) {
            throw new RuntimeException(CommandExec.commandErrorMessage(processBuilder, diagnosticOutput.get()), e);
        }
    }

    private boolean readStream(InputStream inputStream, OutputStream outputStream, String command, byte[] buffer) {
        int nread;
        try {
            nread = inputStream.read(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read input from child process for command '" + command + "'", e);
        }
        if (nread < 0) {
            return true;
        }
        try {
            outputStream.write(buffer, 0, nread);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write output from child process for command '" + command + "'", e);
        }
        finally {
            try {
                outputStream.flush();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write output from child process for command '" + command + "'", e);
            }
        }
        return false;
    }

    private static String commandErrorMessage(ProcessBuilder processBuilder, String diagnosticOutput) {
        String message = "Could not run command " + String.join((CharSequence)" ", processBuilder.command());
        if (!diagnosticOutput.isEmpty()) {
            message = message + "\nOutput:\n======\n" + diagnosticOutput + "======";
        }
        return message;
    }

    public class RunHandle {
        private final ProcessBuilder processBuilder;
        private final Process process;
        private final Supplier<String> diagnosticOutput;
        private final ExecutorService executor;

        RunHandle(ProcessBuilder processBuilder, Process process, Supplier<String> diagnosticOutput, ExecutorService executor) {
            this.processBuilder = processBuilder;
            this.process = process;
            this.diagnosticOutput = diagnosticOutput;
            this.executor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForSuccess() {
            int result = 0;
            Exception failure = null;
            try {
                result = this.process.waitFor();
            }
            catch (Exception e) {
                failure = e;
            }
            finally {
                this.shutdownExecutor();
            }
            if (failure != null) {
                throw new RuntimeException(CommandExec.commandErrorMessage(this.processBuilder, this.diagnosticOutput.get()), failure);
            }
            if (result != 0) {
                throw new RuntimeException(CommandExec.commandErrorMessage(this.processBuilder, this.diagnosticOutput.get()));
            }
        }

        public void waitForSuccess(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            Future<?> future = this.executor.submit(this::waitForSuccess);
            future.get(timeout, unit);
        }

        public void interrupt() {
            int pid;
            try {
                Field field = this.process.getClass().getDeclaredField("pid");
                field.setAccessible(true);
                pid = (Integer)field.get(this.process);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            CommandExec.this.run("kill", String.valueOf(pid));
            try {
                this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.shutdownExecutor();
        }

        public void kill() {
            this.process.destroy();
            this.shutdownExecutor();
        }

        private void shutdownExecutor() {
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

