/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.yourkit;

import java.io.File;
import org.gradle.profiler.OperatingSystem;

public class YourKit {
    static final String ENIVONMENT_VARIABLE = "YOURKIT_HOME";
    private static final String YOURKIT_HOME = System.getenv("YOURKIT_HOME");

    public static File findYourKitHome() {
        File ykHome;
        if (YOURKIT_HOME != null && (ykHome = new File(YOURKIT_HOME)).exists()) {
            return ykHome;
        }
        File applicationsDir = new File("/Applications");
        if (!applicationsDir.isDirectory()) {
            return null;
        }
        for (File file : applicationsDir.listFiles()) {
            if (!file.getName().matches("YourKit.*\\.app")) continue;
            return file;
        }
        return null;
    }

    public static File findControllerJar() {
        File yourKitHome = YourKit.findYourKitHome();
        return YourKit.tryLocations(yourKitHome, "Contents/Resources/lib/yjp-controller-api-redist.jar", "lib/yjp-controller-api-redist.jar");
    }

    public static File findJniLib() {
        File yourKitHome = YourKit.findYourKitHome();
        if (OperatingSystem.isWindows()) {
            return YourKit.tryLocations(yourKitHome, "bin/win64/yjpagent.dll");
        }
        String macLibLocationPrefix = "Contents/Resources/bin/mac/libyjpagent.";
        return YourKit.tryLocations(yourKitHome, macLibLocationPrefix + "jnilib", macLibLocationPrefix + "dylib", "bin/linux-x86-64/libyjpagent.so");
    }

    private static File tryLocations(File baseDir, String ... candidates) {
        for (String candidate : candidates) {
            File location = new File(baseDir, candidate);
            if (!location.exists()) continue;
            return location;
        }
        return null;
    }
}

