/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.time.Duration;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.profiler.BuildAction;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.buildops.BuildOperationExecutionData;
import org.gradle.profiler.buildops.BuildOperationUtil;
import org.gradle.profiler.result.BuildInvocationResult;
import org.gradle.profiler.result.Sample;
import org.gradle.profiler.result.SingleInvocationSample;

public class GradleBuildInvocationResult
extends BuildInvocationResult {
    private final Duration garbageCollectionTime;
    private final Duration timeToTaskExecution;
    private final Map<String, BuildOperationExecutionData> totalBuildOperationExecutionData;
    private final String daemonPid;
    public static final Sample<GradleBuildInvocationResult> GARBAGE_COLLECTION_TIME = new SingleInvocationSample<GradleBuildInvocationResult>(){

        @Override
        public String getName() {
            return "garbage collection time";
        }

        @Override
        public Duration extractTotalDurationFrom(GradleBuildInvocationResult result) {
            return result.garbageCollectionTime;
        }
    };
    public static final Sample<GradleBuildInvocationResult> TIME_TO_TASK_EXECUTION = new SingleInvocationSample<GradleBuildInvocationResult>(){

        @Override
        public String getName() {
            return "task start";
        }

        @Override
        public Duration extractTotalDurationFrom(GradleBuildInvocationResult result) {
            return result.timeToTaskExecution;
        }
    };

    public GradleBuildInvocationResult(BuildContext buildContext, BuildAction.BuildActionResult actionResult, @Nullable Duration garbageCollectionTime, @Nullable Duration timeToTaskExecution, Map<String, BuildOperationExecutionData> totalBuildOperationExecutionData, String daemonPid) {
        super(buildContext, actionResult);
        this.garbageCollectionTime = garbageCollectionTime;
        this.timeToTaskExecution = timeToTaskExecution;
        this.totalBuildOperationExecutionData = totalBuildOperationExecutionData;
        this.daemonPid = daemonPid;
    }

    public String getDaemonPid() {
        return this.daemonPid;
    }

    public Duration getGarbageCollectionTime() {
        return this.garbageCollectionTime;
    }

    public Duration getTimeToTaskExecution() {
        return this.timeToTaskExecution;
    }

    public Map<String, BuildOperationExecutionData> getTotalBuildOperationExecutionData() {
        return this.totalBuildOperationExecutionData;
    }

    public static Sample<GradleBuildInvocationResult> sampleBuildOperation(final String buildOperationDetailsClass) {
        return new Sample<GradleBuildInvocationResult>(){

            @Override
            public String getName() {
                return BuildOperationUtil.getSimpleBuildOperationName(buildOperationDetailsClass);
            }

            @Override
            public Duration extractTotalDurationFrom(GradleBuildInvocationResult result) {
                return this.getExecutionData(result).getTotalDuration();
            }

            @Override
            public int extractTotalCountFrom(GradleBuildInvocationResult result) {
                return this.getExecutionData(result).getTotalCount();
            }

            private BuildOperationExecutionData getExecutionData(GradleBuildInvocationResult result) {
                return result.totalBuildOperationExecutionData.getOrDefault(buildOperationDetailsClass, BuildOperationExecutionData.ZERO);
            }
        };
    }
}

