/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.io.File;
import org.gradle.profiler.GradleScenarioDefinition;
import org.gradle.profiler.InvocationSettings;

public class ScenarioSettings {
    private static final String PROFILE_JFR_SUFFIX = ".jfr";
    private static final String PROFILE_JFR_DIRECTORY_SUFFIX = "-jfr";
    private final InvocationSettings invocationSettings;
    private final GradleScenarioDefinition scenario;

    public ScenarioSettings(InvocationSettings invocationSettings, GradleScenarioDefinition scenario) {
        this.invocationSettings = invocationSettings;
        this.scenario = scenario;
    }

    public InvocationSettings getInvocationSettings() {
        return this.invocationSettings;
    }

    public GradleScenarioDefinition getScenario() {
        return this.scenario;
    }

    public File computeJfrProfilerOutputLocation() {
        GradleScenarioDefinition scenario = this.getScenario();
        if (scenario.createsMultipleProcesses()) {
            File jfrFilesDirectory = this.profilerOutputLocationFor(PROFILE_JFR_DIRECTORY_SUFFIX);
            jfrFilesDirectory.mkdirs();
            return jfrFilesDirectory;
        }
        return this.profilerOutputLocationFor(PROFILE_JFR_SUFFIX);
    }

    public File profilerOutputLocationFor(String suffix) {
        return new File(this.getProfilerOutputBaseDir(), this.getProfilerOutputBaseName() + suffix);
    }

    public File getProfilerOutputBaseDir() {
        return this.scenario.getOutputDir();
    }

    public String getProfilerOutputBaseName() {
        return this.scenario.getProfileName();
    }
}

