/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.studio.launcher;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.profiler.CommandExec;
import org.gradle.profiler.Logging;

public class LaunchConfiguration {
    private final Path javaCommand;
    private final List<Path> classPath;
    private final Map<String, String> systemProperties;
    private final String mainClass;
    private final Path agentJar;
    private final Path supportJar;
    private final List<Path> sharedJars;
    private final List<Path> studioPluginJars;
    private final Path studioPluginsDir;
    private final Path studioLogsDir;
    private final List<String> commandLine;
    private final Path studioInstallDir;

    public LaunchConfiguration(Path javaCommand, Path studioInstallDir, List<Path> classPath, Map<String, String> systemProperties, String mainClass, Path agentJar, Path supportJar, List<Path> sharedJars, List<Path> studioPluginJars, Path studioPluginsDir, Path studioLogsDir, List<String> commandLine) {
        this.javaCommand = javaCommand;
        this.studioInstallDir = studioInstallDir;
        this.classPath = classPath;
        this.systemProperties = systemProperties;
        this.mainClass = mainClass;
        this.agentJar = agentJar;
        this.supportJar = supportJar;
        this.sharedJars = sharedJars;
        this.studioPluginJars = studioPluginJars;
        this.studioPluginsDir = studioPluginsDir;
        this.studioLogsDir = studioLogsDir;
        this.commandLine = commandLine;
    }

    public Path getJavaCommand() {
        return this.javaCommand;
    }

    public Path studioInstallDir() {
        return this.studioInstallDir;
    }

    public List<Path> getClassPath() {
        return this.classPath;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public Path getAgentJar() {
        return this.agentJar;
    }

    public Path getSupportJar() {
        return this.supportJar;
    }

    public List<Path> getSharedJars() {
        return this.sharedJars;
    }

    public List<Path> getStudioPluginJars() {
        return this.studioPluginJars;
    }

    public Path getStudioPluginsDir() {
        return this.studioPluginsDir;
    }

    public Path getStudioLogsDir() {
        return this.studioLogsDir;
    }

    public List<String> getCommandLine() {
        return this.commandLine;
    }

    public CommandExec.RunHandle launchStudio(File projectDir) {
        ArrayList<String> commandLine = new ArrayList<String>(this.getCommandLine());
        commandLine.add(projectDir.getAbsolutePath());
        this.logLauncherConfiguration(commandLine);
        return new CommandExec().inDir(this.studioInstallDir().toFile()).start(commandLine);
    }

    private void logLauncherConfiguration(List<String> commandLine) {
        System.out.println();
        Logging.startOperation("Starting Android Studio at " + this.studioInstallDir);
        System.out.println("* Java command: " + this.getJavaCommand());
        System.out.println("* Classpath:");
        this.getClassPath().stream().map(entry -> "  " + entry).forEach(System.out::println);
        System.out.println("* System properties:");
        this.getSystemProperties().forEach((key, value) -> System.out.printf("  %s -> %s%n", key, value));
        System.out.println("* Main class: " + this.getMainClass());
        System.out.println("* Android Studio logs can be found at: " + Paths.get(this.getStudioLogsDir().toString(), "idea.log"));
        System.out.printf("* Using command line: %s%n%n", commandLine);
    }
}

