/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.studio.launcher;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.profiler.OperatingSystem;
import org.gradle.profiler.studio.launcher.StudioConfiguration;

public class StudioConfigurationProvider {
    private static final List<String> DEFAULT_MACOS_JAVA_PATHS = ImmutableList.of((Object)"Contents/jre/Contents/Home/bin/java", (Object)"Contents/jbr/Contents/Home/bin/java");
    private static final List<String> DEFAULT_WINDOWS_JAVA_PATHS = ImmutableList.of((Object)"jre/bin/java.exe", (Object)"jbr/bin/java.exe");
    private static final List<String> DEFAULT_LINUX_JAVA_PATHS = ImmutableList.of((Object)"jre/bin/java", (Object)"jbr/bin/java");
    private static final Pattern LINUX_CLASSPATH_LIB_PATTERN = Pattern.compile(".*(?:CLASS_PATH|CLASSPATH)=.*(?<lib>lib/.+\\.jar).*");
    private static final Pattern WINDOWS_CLASSPATH_LIB_PATTERN = Pattern.compile(".*(?:CLASS_PATH|CLASSPATH)=.*(?<lib>lib\\\\.+\\.jar).*");

    public static StudioConfiguration getLaunchConfiguration(Path studioInstallDir) {
        if (OperatingSystem.isMacOS()) {
            return StudioConfigurationProvider.getMacOSConfiguration(studioInstallDir);
        }
        if (OperatingSystem.isWindows()) {
            return StudioConfigurationProvider.getWindowsConfiguration(studioInstallDir);
        }
        return StudioConfigurationProvider.getLinuxConfiguration(studioInstallDir);
    }

    @VisibleForTesting
    static StudioConfiguration getWindowsConfiguration(Path studioInstallDir) {
        Path studioBat = studioInstallDir.resolve("bin/studio.bat");
        List<Path> classPath = StudioConfigurationProvider.parseClasspathFromFile(studioInstallDir, studioBat, WINDOWS_CLASSPATH_LIB_PATTERN);
        return StudioConfigurationProvider.getWindowsAndLinuxConfiguration(studioInstallDir, classPath);
    }

    @VisibleForTesting
    static StudioConfiguration getLinuxConfiguration(Path studioInstallDir) {
        Path studioSh = studioInstallDir.resolve("bin/studio.sh");
        List<Path> classPath = StudioConfigurationProvider.parseClasspathFromFile(studioInstallDir, studioSh, LINUX_CLASSPATH_LIB_PATTERN);
        return StudioConfigurationProvider.getWindowsAndLinuxConfiguration(studioInstallDir, classPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Path> parseClasspathFromFile(Path studioInstallDir, Path studioExec, Pattern libPattern) {
        try (Stream<String> lines = Files.lines(studioExec, StandardCharsets.UTF_8);){
            List<Path> list = lines.map(libPattern::matcher).filter(Matcher::matches).map(matcher -> studioInstallDir.resolve(matcher.group("lib"))).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static StudioConfiguration getWindowsAndLinuxConfiguration(Path studioInstallDir, List<Path> classPath) {
        String mainClass = "com.intellij.idea.Main";
        Path javaPath = StudioConfigurationProvider.getJavaPath(studioInstallDir);
        ImmutableMap systemProperties = ImmutableMap.builder().put((Object)"idea.vendor.name", (Object)"Google").put((Object)"idea.executable", (Object)"studio").put((Object)"idea.platform.prefix", (Object)"AndroidStudio").build();
        return new StudioConfiguration(mainClass, studioInstallDir, javaPath, classPath, (Map<String, String>)systemProperties);
    }

    private static StudioConfiguration getMacOSConfiguration(Path studioInstallDir) {
        Path actualInstallDir;
        Dict entries = StudioConfigurationProvider.parseMacOsPlist(studioInstallDir.resolve("Contents/Info.plist"));
        if ("jetbrains-toolbox-launcher".equals(entries.string("CFBundleExecutable"))) {
            actualInstallDir = Paths.get(entries.string("JetBrainsToolboxApp"), new String[0]);
            entries = StudioConfigurationProvider.parseMacOsPlist(actualInstallDir.resolve("Contents/Info.plist"));
        } else {
            actualInstallDir = studioInstallDir;
        }
        Dict jvmOptions = entries.dict("JVMOptions");
        List<Path> classPath = Arrays.stream(jvmOptions.string("ClassPath").split(":")).map(s -> FileSystems.getDefault().getPath(s.replace("$APP_PACKAGE", actualInstallDir.toString()), new String[0])).collect(Collectors.toList());
        Map<String, String> systemProperties = StudioConfigurationProvider.mapValues(jvmOptions.dict("Properties").toMap(), v -> v.replace("$APP_PACKAGE", actualInstallDir.toString()));
        String mainClass = jvmOptions.string("MainClass");
        Path javaPath = StudioConfigurationProvider.getJavaPath(actualInstallDir);
        return new StudioConfiguration(mainClass, actualInstallDir, javaPath, classPath, systemProperties);
    }

    private static Path getJavaPath(Path studioInstallDir) {
        return StudioConfigurationProvider.getDefaultJavaPathsForOs().stream().map(studioInstallDir::resolve).filter(path -> path.toFile().exists()).findFirst().orElseThrow(() -> new RuntimeException("Could not find Java executable in " + studioInstallDir));
    }

    private static List<String> getDefaultJavaPathsForOs() {
        if (OperatingSystem.isMacOS()) {
            return DEFAULT_MACOS_JAVA_PATHS;
        }
        if (OperatingSystem.isWindows()) {
            return DEFAULT_WINDOWS_JAVA_PATHS;
        }
        return DEFAULT_LINUX_JAVA_PATHS;
    }

    private static Dict parseMacOsPlist(Path infoFile) {
        try {
            return new Dict((NSDictionary)PropertyListParser.parse((File)infoFile.toFile()));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not parse '%s'.", infoFile), e);
        }
    }

    private static <T, S> Map<String, S> mapValues(Map<String, T> map, Function<T, S> mapper) {
        LinkedHashMap<String, S> result = new LinkedHashMap<String, S>();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            result.put(entry.getKey(), mapper.apply(entry.getValue()));
        }
        return result;
    }

    private static class Dict {
        private final NSDictionary contents;

        public Dict(NSDictionary contents) {
            this.contents = contents;
        }

        Dict dict(String key) {
            return new Dict((NSDictionary)this.getEntry(key));
        }

        String string(String key) {
            return ((NSString)this.getEntry(key)).getContent();
        }

        Map<String, String> toMap() {
            return StudioConfigurationProvider.mapValues((Map)this.contents, v -> ((NSString)v).getContent());
        }

        private NSObject getEntry(String key) {
            NSObject value = this.contents.get((Object)key);
            if (value == null) {
                throw new IllegalArgumentException(String.format("Dictionary does not contain entry '%s'.", key));
            }
            return value;
        }
    }
}

