/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.time.Duration;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.profiler.BuildAction;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.buildops.BuildOperationExecutionData;
import org.gradle.profiler.buildops.BuildOperationUtil;
import org.gradle.profiler.result.BuildInvocationResult;
import org.gradle.profiler.result.DurationSample;
import org.gradle.profiler.result.Sample;
import org.gradle.profiler.result.SingleInvocationDurationSample;

public class GradleBuildInvocationResult
extends BuildInvocationResult {
    private final Duration garbageCollectionTime;
    private final Long localBuildCacheSize;
    private final Duration timeToTaskExecution;
    private final Map<String, BuildOperationExecutionData> totalBuildOperationExecutionData;
    private final String daemonPid;
    public static final Sample<GradleBuildInvocationResult> GARBAGE_COLLECTION_TIME = SingleInvocationDurationSample.from("garbage collection time", GradleBuildInvocationResult::getGarbageCollectionTime);
    public static final Sample<GradleBuildInvocationResult> LOCAL_BUILD_CACHE_SIZE = new Sample<GradleBuildInvocationResult>("local build cache size", "MiB"){

        @Override
        public double extractValue(GradleBuildInvocationResult result) {
            return (double)result.getLocalBuildCacheSize().longValue() / 1024.0 / 1024.0;
        }

        @Override
        public int extractTotalCountFrom(GradleBuildInvocationResult result) {
            return 1;
        }
    };
    public static final Sample<GradleBuildInvocationResult> TIME_TO_TASK_EXECUTION = SingleInvocationDurationSample.from("task start", GradleBuildInvocationResult::getTimeToTaskExecution);

    public GradleBuildInvocationResult(BuildContext buildContext, BuildAction.BuildActionResult actionResult, @Nullable Duration garbageCollectionTime, @Nullable Long localBuildCacheSize, @Nullable Duration timeToTaskExecution, Map<String, BuildOperationExecutionData> totalBuildOperationExecutionData, String daemonPid) {
        super(buildContext, actionResult);
        this.garbageCollectionTime = garbageCollectionTime;
        this.localBuildCacheSize = localBuildCacheSize;
        this.timeToTaskExecution = timeToTaskExecution;
        this.totalBuildOperationExecutionData = totalBuildOperationExecutionData;
        this.daemonPid = daemonPid;
    }

    public String getDaemonPid() {
        return this.daemonPid;
    }

    public Duration getGarbageCollectionTime() {
        return this.garbageCollectionTime;
    }

    public Long getLocalBuildCacheSize() {
        return this.localBuildCacheSize;
    }

    public Duration getTimeToTaskExecution() {
        return this.timeToTaskExecution;
    }

    public Map<String, BuildOperationExecutionData> getTotalBuildOperationExecutionData() {
        return this.totalBuildOperationExecutionData;
    }

    public static Sample<GradleBuildInvocationResult> sampleBuildOperation(final String buildOperationDetailsClass) {
        return new DurationSample<GradleBuildInvocationResult>(BuildOperationUtil.getSimpleBuildOperationName(buildOperationDetailsClass)){

            @Override
            protected Duration extractTotalDurationFrom(GradleBuildInvocationResult result) {
                return Duration.ofMillis(this.getExecutionData(result).getValue());
            }

            @Override
            public int extractTotalCountFrom(GradleBuildInvocationResult result) {
                return this.getExecutionData(result).getTotalCount();
            }

            private BuildOperationExecutionData getExecutionData(GradleBuildInvocationResult result) {
                return result.totalBuildOperationExecutionData.getOrDefault(buildOperationDetailsClass, BuildOperationExecutionData.ZERO);
            }
        };
    }
}

