/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.io.File;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.gradle.profiler.BuildAction;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.GradleBuildConfiguration;
import org.gradle.profiler.GradleBuildInvoker;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.ScenarioDefinition;
import org.gradle.profiler.ScenarioSettings;
import org.gradle.profiler.buildops.BuildOperationUtil;
import org.gradle.util.GradleVersion;

public class GradleScenarioDefinition
extends ScenarioDefinition {
    private final GradleBuildInvoker invoker;
    private final GradleBuildConfiguration buildConfiguration;
    private final BuildAction buildAction;
    private final BuildAction cleanupAction;
    private final List<String> gradleArgs;
    private final Map<String, String> systemProperties;
    private final List<String> jvmArgs;
    private final List<String> measuredBuildOperations;

    public GradleScenarioDefinition(String name, String title, GradleBuildInvoker invoker, GradleBuildConfiguration buildConfiguration, BuildAction buildAction, BuildAction cleanupAction, List<String> gradleArgs, Map<String, String> systemProperties, List<BuildMutator> buildMutators, int warmUpCount, int buildCount, File outputDir, List<String> jvmArgs, List<String> measuredBuildOperations) {
        super(name, title, buildMutators, warmUpCount, buildCount, outputDir);
        this.invoker = invoker;
        this.buildAction = buildAction;
        this.buildConfiguration = buildConfiguration;
        this.cleanupAction = cleanupAction;
        this.gradleArgs = gradleArgs;
        this.systemProperties = systemProperties;
        this.jvmArgs = jvmArgs;
        this.measuredBuildOperations = measuredBuildOperations;
    }

    @Override
    public String getDisplayName() {
        return this.getTitle() + " using " + this.buildConfiguration.getGradleVersion();
    }

    @Override
    public String getProfileName() {
        return GradleScenarioDefinition.safeFileName(this.getName()) + "-" + this.buildConfiguration.getGradleVersion().getVersion();
    }

    public static String safeFileName(String name) {
        return name.replace("/", "-");
    }

    @Override
    public String getBuildToolDisplayName() {
        return this.buildConfiguration.getGradleVersion().toString();
    }

    @Override
    public String getTasksDisplayName() {
        return this.buildAction.getShortDisplayName();
    }

    public List<String> getGradleArgs() {
        return this.gradleArgs;
    }

    @Override
    public GradleBuildInvoker getInvoker() {
        return this.invoker;
    }

    public BuildAction getAction() {
        return this.buildAction;
    }

    public BuildAction getCleanupAction() {
        return this.cleanupAction;
    }

    public GradleBuildConfiguration getBuildConfiguration() {
        return this.buildConfiguration;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public List<String> getMeasuredBuildOperations() {
        return this.measuredBuildOperations;
    }

    public boolean createsMultipleProcesses() {
        if (this.getBuildCount() <= 1) {
            return false;
        }
        return this.getInvoker().isDoesNotUseDaemon() || !this.getInvoker().isReuseDaemon();
    }

    @Override
    public void visitProblems(InvocationSettings settings, Consumer<String> reporter) {
        if (this.getWarmUpCount() < 1) {
            reporter.accept("You can not skip warm-ups when profiling or benchmarking a Gradle build. Use --no-daemon or --cold-daemon if you want to profile or benchmark JVM startup");
        }
        if (settings.isMeasureGarbageCollection() && this.isBuildServiceUnsupported()) {
            reporter.accept("Measuring garbage collection is only supported for Gradle 6.1-milestone-3 and later");
        }
        if (settings.isMeasureLocalBuildCache() && this.isBuildServiceUnsupported()) {
            reporter.accept("Measuring local build cache size is only supported for Gradle 6.1-milestone-3 and later");
        }
        if (settings.isMeasureConfigTime() && this.isBuildServiceUnsupported()) {
            reporter.accept("Measuring build configuration is only supported for Gradle 6.1-milestone-3 and later");
        }
        settings.getProfiler().validate(new ScenarioSettings(settings, this), reporter);
    }

    private boolean isBuildServiceUnsupported() {
        return this.buildConfiguration.getGradleVersion().compareTo(GradleVersion.version((String)"6.1-milestone-3")) < 0;
    }

    @Override
    protected void printDetail(PrintStream out) {
        out.println("  " + this.getBuildConfiguration().getGradleVersion() + " (" + this.getBuildConfiguration().getGradleHome() + ")");
        out.println("  Run using: " + this.getInvoker());
        out.println("  Run: " + this.getAction().getDisplayName());
        out.println("  Cleanup: " + this.getCleanupAction().getDisplayName());
        out.println("  Gradle args: " + this.getGradleArgs());
        if (!this.getSystemProperties().isEmpty()) {
            out.println("  System properties:");
            for (Map.Entry<String, String> entry : this.getSystemProperties().entrySet()) {
                out.println("    " + entry.getKey() + "=" + entry.getValue());
            }
        }
        if (!this.jvmArgs.isEmpty()) {
            out.println("  Jvm args: " + this.getJvmArgs());
        }
        if (!this.measuredBuildOperations.isEmpty()) {
            out.println("  Measured build operations: " + this.measuredBuildOperations.stream().map(BuildOperationUtil::getSimpleBuildOperationName).sorted().collect(Collectors.joining(", ")));
        }
    }
}

