/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.report;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.Writer;
import java.lang.reflect.Type;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.gradle.profiler.GradleScenarioDefinition;
import org.gradle.profiler.OperatingSystem;
import org.gradle.profiler.ScenarioDefinition;
import org.gradle.profiler.Version;
import org.gradle.profiler.report.BuildScenarioResult;
import org.gradle.profiler.result.BuildInvocationResult;
import org.gradle.profiler.result.Sample;

public class JsonResultWriter {
    private final boolean pretty;

    public JsonResultWriter(boolean pretty) {
        this.pretty = pretty;
    }

    public void write(@Nullable String title, Temporal reportDate, List<? extends BuildScenarioResult<?>> scenarios, Writer writer) {
        GsonBuilder builder = new GsonBuilder();
        if (this.pretty) {
            builder.setPrettyPrinting();
        }
        Gson gson = builder.registerTypeHierarchyAdapter(BuildScenarioResult.class, this::serializeScenarioResult).registerTypeHierarchyAdapter(ScenarioDefinition.class, new ScenarioSerializer()).registerTypeHierarchyAdapter(GradleScenarioDefinition.class, (Object)new GradleScenarioSerializer()).registerTypeHierarchyAdapter(Temporal.class, (date, type, context) -> new JsonPrimitive(DateTimeFormatter.ISO_INSTANT.format((TemporalAccessor)date))).create();
        gson.toJson((Object)new Output(title, reportDate, new Environment(), scenarios), (Appendable)writer);
    }

    private <T extends BuildInvocationResult> JsonObject serializeScenarioResult(BuildScenarioResult<T> scenarioResult, Type type, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        List<T> results = scenarioResult.getResults();
        JsonObject jsonDefinition = (JsonObject)context.serialize((Object)scenarioResult.getScenarioDefinition());
        String scenarioId = results.isEmpty() ? null : ((BuildInvocationResult)results.get(0)).getBuildContext().getUniqueScenarioId();
        jsonDefinition.addProperty("id", scenarioId);
        json.add("definition", (JsonElement)jsonDefinition);
        JsonArray samplesJson = new JsonArray();
        List<Sample<T>> samples = scenarioResult.getSamples();
        for (Sample<T> sample : samples) {
            samplesJson.add((JsonElement)this.serializeSample(sample));
        }
        json.add("samples", (JsonElement)samplesJson);
        JsonArray iterationsJson = new JsonArray();
        for (BuildInvocationResult result : results) {
            iterationsJson.add((JsonElement)this.serializeIteration(result, samples));
        }
        json.add("iterations", (JsonElement)iterationsJson);
        return json;
    }

    private JsonObject serializeSample(Sample<?> sample) {
        JsonObject json = new JsonObject();
        json.addProperty("name", sample.getName());
        json.addProperty("unit", sample.getUnit());
        return json;
    }

    private <T extends BuildInvocationResult> JsonObject serializeIteration(T result, List<? extends Sample<? super T>> samples) {
        JsonObject json = new JsonObject();
        json.addProperty("id", result.getBuildContext().getUniqueBuildId());
        json.addProperty("phase", result.getBuildContext().getPhase().name());
        json.addProperty("iteration", (Number)result.getBuildContext().getIteration());
        json.addProperty("title", result.getBuildContext().getDisplayName());
        JsonObject valuesJson = new JsonObject();
        for (Sample<T> sample : samples) {
            valuesJson.addProperty(sample.getName(), (Number)sample.extractValue(result));
        }
        json.add("values", (JsonElement)valuesJson);
        return json;
    }

    private static JsonArray toJson(Stream<String> array) {
        JsonArray json = new JsonArray();
        array.forEach(arg_0 -> ((JsonArray)json).add(arg_0));
        return json;
    }

    private static JsonObject toJson(Map<String, String> values) {
        JsonObject json = new JsonObject();
        values.forEach((arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
        return json;
    }

    private static class GradleScenarioSerializer
    extends ScenarioSerializer<GradleScenarioDefinition> {
        private GradleScenarioSerializer() {
        }

        @Override
        public JsonObject serialize(GradleScenarioDefinition scenario, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = super.serialize(scenario, typeOfSrc, context);
            json.addProperty("version", scenario.getBuildConfiguration().getGradleVersion().getVersion());
            json.addProperty("gradleHome", scenario.getBuildConfiguration().getGradleHome().getAbsolutePath());
            json.addProperty("javaHome", scenario.getBuildConfiguration().getJavaHome().getAbsolutePath());
            json.addProperty("usesScanPlugin", Boolean.valueOf(scenario.getBuildConfiguration().isUsesScanPlugin()));
            json.addProperty("action", scenario.getAction().getDisplayName());
            json.addProperty("cleanup", scenario.getCleanupAction().getDisplayName());
            json.addProperty("invoker", scenario.getInvoker().toString());
            json.add("mutators", (JsonElement)JsonResultWriter.toJson(scenario.getBuildMutators().stream().map(Object::toString)));
            json.add("args", (JsonElement)JsonResultWriter.toJson(scenario.getGradleArgs().stream()));
            json.add("jvmArgs", (JsonElement)JsonResultWriter.toJson(Stream.concat(scenario.getBuildConfiguration().getJvmArguments().stream(), scenario.getJvmArgs().stream())));
            json.add("systemProperties", (JsonElement)JsonResultWriter.toJson(scenario.getSystemProperties()));
            return json;
        }
    }

    private static class ScenarioSerializer<T extends ScenarioDefinition>
    implements JsonSerializer<T> {
        private ScenarioSerializer() {
        }

        @OverridingMethodsMustInvokeSuper
        public JsonObject serialize(T scenario, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("name", ((ScenarioDefinition)scenario).getName());
            json.addProperty("title", ((ScenarioDefinition)scenario).getTitle());
            json.addProperty("displayName", ((ScenarioDefinition)scenario).getDisplayName());
            json.addProperty("buildTool", ((ScenarioDefinition)scenario).getBuildToolDisplayName());
            json.addProperty("tasks", ((ScenarioDefinition)scenario).getTasksDisplayName());
            return json;
        }
    }

    private static class Output {
        final String title;
        final Temporal date;
        final Environment environment;
        final List<? extends BuildScenarioResult<?>> scenarios;

        public Output(String title, Temporal date, Environment environment, List<? extends BuildScenarioResult<?>> scenarios) {
            this.title = title;
            this.date = date;
            this.environment = environment;
            this.scenarios = scenarios;
        }
    }

    private static class Environment {
        final String profilerVersion = Version.getVersion();
        final String operatingSystem = OperatingSystem.getId();
    }
}

