/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.time.Duration;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.BuildStep;
import org.gradle.profiler.BuildStepAction;
import org.gradle.profiler.Logging;
import org.gradle.profiler.result.BuildInvocationResult;

public class RunBuildStepAction<T extends BuildInvocationResult>
implements BuildStepAction<T> {
    private final BuildStepAction<? extends T> action;
    private final BuildMutator mutator;

    public RunBuildStepAction(BuildStepAction<? extends T> action, BuildMutator mutator) {
        this.action = action;
        this.mutator = mutator;
    }

    @Override
    public boolean isDoesSomething() {
        return this.action.isDoesSomething();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T run(BuildContext buildContext, BuildStep buildStep) {
        Logging.startOperation((String)("Running " + buildContext.getDisplayName()));
        this.mutator.beforeBuild(buildContext);
        RuntimeException failure = null;
        try {
            T result = this.action.run(buildContext, buildStep);
            RunBuildStepAction.printExecutionTime(result.getExecutionTime());
            T t = result;
            return t;
        }
        catch (RuntimeException e) {
            failure = e;
        }
        catch (Throwable t) {
            failure = new RuntimeException(t);
        }
        finally {
            this.mutator.afterBuild(buildContext, (Throwable)failure);
        }
        throw failure;
    }

    private static void printExecutionTime(Duration executionTime) {
        System.out.println("Execution time " + executionTime.toMillis() + " ms");
    }
}

