/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import org.gradle.profiler.BuildContext;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.BuildStep;
import org.gradle.profiler.BuildStepAction;
import org.gradle.profiler.Logging;
import org.gradle.profiler.result.BuildInvocationResult;

public class RunCleanupStepAction<T extends BuildInvocationResult>
implements BuildStepAction<T> {
    private final BuildStepAction<T> cleanupAction;
    private final BuildMutator mutator;

    public RunCleanupStepAction(BuildStepAction<T> cleanupAction, BuildMutator mutator) {
        this.cleanupAction = cleanupAction;
        this.mutator = mutator;
    }

    @Override
    public boolean isDoesSomething() {
        return this.cleanupAction.isDoesSomething();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T run(BuildContext buildContext, BuildStep buildStep) {
        if (this.cleanupAction.isDoesSomething()) {
            Logging.startOperation((String)("Running cleanup for " + buildContext.getDisplayName()));
            this.mutator.beforeCleanup(buildContext);
            RuntimeException failure = null;
            try {
                this.cleanupAction.run(buildContext, buildStep);
                T t = null;
                return t;
            }
            catch (RuntimeException e) {
                failure = e;
            }
            catch (Throwable t) {
                failure = new RuntimeException(t);
            }
            finally {
                this.mutator.afterCleanup(buildContext, (Throwable)failure);
            }
            throw failure;
        }
        return null;
    }
}

