/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import org.gradle.profiler.BuildContext;
import org.gradle.profiler.Phase;
import org.gradle.profiler.ScenarioContext;

public class DefaultBuildContext
implements BuildContext {
    private final ScenarioContext scenarioContext;
    private final Phase phase;
    private final int iteration;

    protected DefaultBuildContext(ScenarioContext scenarioContext, Phase phase, int iteration) {
        this.scenarioContext = scenarioContext;
        this.phase = phase;
        this.iteration = iteration;
    }

    @Override
    public String getUniqueScenarioId() {
        return this.scenarioContext.getUniqueScenarioId();
    }

    @Override
    public BuildContext withBuild(Phase phase, int count) {
        return this.scenarioContext.withBuild(phase, count);
    }

    @Override
    public String getUniqueBuildId() {
        return String.format("%s_%s_%d", this.getUniqueScenarioId(), this.phase.name(), this.iteration);
    }

    @Override
    public Phase getPhase() {
        return this.phase;
    }

    @Override
    public int getIteration() {
        return this.iteration;
    }

    @Override
    public String getDisplayName() {
        return this.phase.displayBuildNumber(this.iteration);
    }
}

