/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.buildops;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.profiler.buildops.BuildOperationExecutionData;
import org.gradle.profiler.instrument.GradleInstrumentation;

public class BuildOperationInstrumentation
extends GradleInstrumentation {
    private final boolean measureGarbageCollection;
    private final File totalGarbageCollectionTimeDataFile;
    private final boolean measureLocalBuildCache;
    private final File localBuildCacheDataFile;
    private final boolean measureConfigTime;
    private final File configurationTimeDataFile;
    private final Map<String, File> buildOperationDataFiles;

    public BuildOperationInstrumentation(boolean measureGarbageCollection, boolean measureLocalBuildCache, boolean measureConfigTime, List<String> measuredBuildOperations) throws IOException {
        this.measureGarbageCollection = measureGarbageCollection;
        this.totalGarbageCollectionTimeDataFile = File.createTempFile("gradle-profiler", "gc-time");
        this.measureLocalBuildCache = measureLocalBuildCache;
        this.localBuildCacheDataFile = File.createTempFile("gradle-profiler", "local-build-cache");
        this.measureConfigTime = measureConfigTime;
        this.configurationTimeDataFile = File.createTempFile("gradle-profiler", "build-ops-config-time");
        this.configurationTimeDataFile.deleteOnExit();
        this.buildOperationDataFiles = measuredBuildOperations.stream().collect(Collectors.toMap(Function.identity(), BuildOperationInstrumentation::createBuildOperationTempFile));
    }

    public boolean requiresInitScript() {
        return this.measureGarbageCollection || this.measureLocalBuildCache || this.measureConfigTime || !this.buildOperationDataFiles.isEmpty();
    }

    private static File createBuildOperationTempFile(String op) {
        try {
            File tempFile = Files.createTempFile("gradle-profiler", "build-ops-" + op, new FileAttribute[0]).toFile();
            tempFile.deleteOnExit();
            return tempFile;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected void generateInitScriptBody(PrintWriter writer) {
        writer.print("new org.gradle.trace.buildops.BuildOperationTrace(gradle)");
        if (this.measureGarbageCollection) {
            writer.print(".measureGarbageCollection(" + this.newFile(this.totalGarbageCollectionTimeDataFile) + ")");
        }
        if (this.measureLocalBuildCache) {
            writer.print(".measureLocalBuildCache(" + this.newFile(this.localBuildCacheDataFile) + ")");
        }
        if (this.measureConfigTime) {
            writer.print(".measureConfigurationTime(" + this.newFile(this.configurationTimeDataFile) + ")");
        }
        if (!this.buildOperationDataFiles.isEmpty()) {
            writer.print(".measureBuildOperations(");
            this.buildOperationDataFiles.forEach((opName, dataFile) -> writer.print(String.format("'%s': %s,", opName, this.newFile((File)dataFile))));
            writer.print(")");
        }
    }

    private String newFile(File dataFile) {
        return "new File(new URI('" + dataFile.toURI() + "'))";
    }

    public Optional<Duration> getTotalGarbageCollectionTime() {
        if (this.totalGarbageCollectionTimeDataFile.length() == 0L) {
            return Optional.empty();
        }
        return BuildOperationInstrumentation.readExecutionDataFromFile(this.totalGarbageCollectionTimeDataFile).map(BuildOperationExecutionData::getValue).map(Duration::ofMillis);
    }

    public Optional<Long> getLocalBuildCacheSize() {
        if (this.localBuildCacheDataFile.length() == 0L) {
            return Optional.empty();
        }
        return BuildOperationInstrumentation.readExecutionDataFromFile(this.localBuildCacheDataFile).map(BuildOperationExecutionData::getValue);
    }

    public Optional<Duration> getTimeToTaskExecution() {
        if (this.configurationTimeDataFile.length() == 0L) {
            return Optional.empty();
        }
        return BuildOperationInstrumentation.readExecutionDataFromFile(this.configurationTimeDataFile).map(BuildOperationExecutionData::getValue).map(Duration::ofMillis);
    }

    public Map<String, BuildOperationExecutionData> getTotalBuildOperationExecutionData() {
        return this.buildOperationDataFiles.entrySet().stream().filter(entry -> ((File)entry.getValue()).length() > 0L).collect(Collectors.toMap(Map.Entry::getKey, entry -> BuildOperationInstrumentation.readExecutionDataFromFile((File)entry.getValue()).orElse(BuildOperationExecutionData.ZERO)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<BuildOperationExecutionData> readExecutionDataFromFile(File dataFile) {
        try (Stream<String> lines = Files.lines(dataFile.toPath(), StandardCharsets.UTF_8);){
            Optional<String> lastLine = lines.reduce((ignored, second) -> second);
            Optional<BuildOperationExecutionData> optional = lastLine.map(BuildOperationInstrumentation::parseExecutionDataLine);
            return optional;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not read result from file.", e);
        }
    }

    private static BuildOperationExecutionData parseExecutionDataLine(String line) {
        int separatorIndex = line.indexOf(",");
        if (separatorIndex == -1) {
            throw new IllegalStateException("Unexpected line format: " + line);
        }
        long durationMillis = Long.parseLong(line.substring(0, separatorIndex));
        int count = Integer.parseInt(line.substring(separatorIndex + 1));
        return new BuildOperationExecutionData(durationMillis, count);
    }
}

