/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.studio.launcher;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.gradle.profiler.CommandExec;
import org.gradle.profiler.Logging;
import org.gradle.profiler.studio.tools.StudioSandboxCreator;

public class StudioLauncher {
    private final Path startCommand;
    private final Path studioInstallDir;
    private final String headlessCommand;
    private final List<String> additionalJvmArgs;
    private final StudioSandboxCreator.StudioSandbox studioSandbox;

    public StudioLauncher(Path startCommand, String headlessCommand, Path studioInstallDir, List<String> additionalJvmArgs, StudioSandboxCreator.StudioSandbox studioSandbox) {
        this.startCommand = startCommand;
        this.headlessCommand = headlessCommand;
        this.studioInstallDir = studioInstallDir;
        this.additionalJvmArgs = additionalJvmArgs;
        this.studioSandbox = studioSandbox;
    }

    public CommandExec.RunHandle launchStudio(File projectDir) {
        List<String> commandLine = this.getCommandLine(projectDir);
        this.logLauncherConfiguration(commandLine);
        Map<String, String> environmentVariables = this.writeAdditionalJvmArgs();
        return new CommandExec().inDir(this.studioInstallDir.toFile()).environmentVariables(environmentVariables).start(commandLine);
    }

    private List<String> getCommandLine(File projectDir) {
        if (this.headlessCommand.isEmpty()) {
            return ImmutableList.of((Object)this.startCommand.toAbsolutePath().toString(), (Object)projectDir.getAbsolutePath());
        }
        return ImmutableList.of((Object)this.startCommand.toAbsolutePath().toString(), (Object)this.headlessCommand, (Object)projectDir.getAbsolutePath());
    }

    private void logLauncherConfiguration(List<String> commandLine) {
        System.out.println();
        Logging.startOperation("Starting Android Studio at " + this.studioInstallDir);
        System.out.println("* Start command: " + this.startCommand);
        System.out.println("* Additional JVM args:");
        this.additionalJvmArgs.forEach(arg -> System.out.println("  " + arg));
        System.out.println("* Additional JVM args can be found at: " + this.studioSandbox.getJvmArgsDir().resolve("idea.vmoptions"));
        System.out.println("* Android Studio logs can be found at: " + this.studioSandbox.getLogsDir().resolve("idea.log"));
        System.out.printf("* Using command line: %s%n%n", String.join((CharSequence)" ", commandLine));
    }

    private Map<String, String> writeAdditionalJvmArgs() {
        try {
            Path additionJvmArgsFile = this.studioSandbox.getJvmArgsDir().resolve("idea.vmoptions").toAbsolutePath();
            Files.write(additionJvmArgsFile, this.additionalJvmArgs, new OpenOption[0]);
            return ImmutableMap.builder().put((Object)"STUDIO_VM_OPTIONS", (Object)additionJvmArgsFile.toString()).put((Object)"IDEA_VM_OPTIONS", (Object)additionJvmArgsFile.toString()).build();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

