/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.util.List;
import java.util.stream.Collectors;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.gradle.profiler.CompositeProfiler;
import org.gradle.profiler.Profiler;
import org.gradle.profiler.ProfilerFactory;

class CompositeProfilerFactory
extends ProfilerFactory {
    private final List<ProfilerFactory> delegates;

    CompositeProfilerFactory(List<ProfilerFactory> delegates) {
        this.delegates = delegates;
    }

    public String toString() {
        return this.delegates.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    @Override
    public Profiler createFromOptions(OptionSet parsedOptions) {
        return new CompositeProfiler(this.delegates.stream().map(profiler -> profiler.createFromOptions(parsedOptions)).collect(Collectors.toList()));
    }

    @Override
    public void addOptions(OptionParser parser) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return "composite of " + this.delegates.stream().map(profilerFactory -> profilerFactory.getName()).collect(Collectors.joining(","));
    }
}

