/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.jfr;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.profiler.CommandExec;
import org.gradle.profiler.InstrumentingProfiler;
import org.gradle.profiler.flamegraph.DetailLevel;
import org.gradle.profiler.flamegraph.FlameGraphGenerator;
import org.gradle.profiler.flamegraph.FlameGraphSanitizer;
import org.gradle.profiler.flamegraph.JfrToStacksConverter;
import org.gradle.profiler.flamegraph.Stacks;
import org.gradle.profiler.jfr.JFRArgs;
import org.gradle.profiler.jfr.JcmdRunner;

public class JFRControl
implements InstrumentingProfiler.SnapshotCapturingProfilerController {
    private final JcmdRunner jcmd;
    private final JFRArgs jfrArgs;
    private final File jfrFile;
    private final JfrToStacksConverter stacksConverter = new JfrToStacksConverter((Map<DetailLevel, FlameGraphSanitizer>)new LinkedHashMap<DetailLevel, FlameGraphSanitizer>(){
        {
            this.put(DetailLevel.RAW, FlameGraphSanitizer.raw(new FlameGraphSanitizer.SanitizeFunction[0]));
            this.put(DetailLevel.SIMPLIFIED, FlameGraphSanitizer.simplified(new FlameGraphSanitizer.SanitizeFunction[0]));
        }
    });
    private final FlameGraphGenerator flameGraphGenerator = new FlameGraphGenerator();
    private int counter;

    public JFRControl(JFRArgs args, File jfrFile) {
        this.jcmd = new JcmdRunner();
        this.jfrArgs = args;
        this.jfrFile = jfrFile;
    }

    @Override
    public void startRecording(String pid) throws IOException, InterruptedException {
        this.jcmd.run(pid, "JFR.start", "name=profile", "settings=" + this.jfrArgs.getJfrSettings());
    }

    @Override
    public void stopRecording(String pid) {
        File file;
        if (this.jfrFile.isDirectory()) {
            int n = this.counter++;
            file = new File(this.jfrFile, "jfr-" + n + ".jfr");
        } else {
            file = this.jfrFile;
        }
        File outputFile = file;
        this.jcmd.run(pid, "JFR.stop", "name=profile", "filename=" + outputFile.getAbsolutePath());
    }

    @Override
    public void captureSnapshot(String pid) {
    }

    @Override
    public void stopSession() {
        String jfrFileName = this.jfrFile.getName();
        String outputBaseName = jfrFileName.substring(0, jfrFileName.length() - 4);
        List<Stacks> stackFiles = this.stacksConverter.generateStacks(this.jfrFile, outputBaseName);
        this.flameGraphGenerator.generateGraphs(this.jfrFile.getParentFile(), stackFiles);
        System.out.println("Wrote profiling data to " + this.jfrFile.getPath());
    }

    public String getName() {
        return "jfr";
    }

    private void run(String ... commandLine) {
        new CommandExec().run(commandLine);
    }
}

