/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import java.io.File;
import org.gradle.profiler.mutations.AbstractCleanupMutator;

public abstract class AbstractCacheCleanupMutator
extends AbstractCleanupMutator {
    private final File gradleUserHome;
    private final String cacheNamePrefix;

    public AbstractCacheCleanupMutator(File gradleUserHome, AbstractCleanupMutator.CleanupSchedule schedule, String cacheNamePrefix) {
        super(schedule);
        this.gradleUserHome = gradleUserHome;
        this.cacheNamePrefix = cacheNamePrefix;
    }

    @Override
    protected void cleanup() {
        System.out.println("> Cleaning " + this.cacheNamePrefix + " caches in " + this.gradleUserHome);
        File cachesDir = new File(this.gradleUserHome, "caches");
        if (cachesDir.isDirectory()) {
            File[] cacheDirs = cachesDir.listFiles(file -> file.getName().startsWith(this.cacheNamePrefix));
            if (cacheDirs == null) {
                throw new IllegalStateException(String.format("Cannot find cache directories with prefix '%s' in %s", this.cacheNamePrefix, this.gradleUserHome));
            }
            for (File cacheDir : cacheDirs) {
                if (!cacheDir.isDirectory()) continue;
                this.cleanupCacheDir(cacheDir);
            }
        }
    }

    protected abstract void cleanupCacheDir(File var1);
}

