/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.toolingapi;

import java.util.ArrayList;
import java.util.List;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.gradle.ProjectPublications;

public class FetchProjectPublications
implements BuildAction<List<ProjectPublications>> {
    public List<ProjectPublications> execute(BuildController controller) {
        GradleBuild buildModel = controller.getBuildModel();
        ArrayList<FetchForProject> actions = new ArrayList<FetchForProject>();
        this.collectProjects(buildModel, actions);
        for (GradleBuild build : buildModel.getEditableBuilds()) {
            this.collectProjects(build, actions);
        }
        System.out.println("-> run actions for " + actions.size() + " projects");
        return controller.run(actions);
    }

    private void collectProjects(GradleBuild build, List<FetchForProject> actions) {
        for (BasicGradleProject project : build.getProjects()) {
            actions.add(new FetchForProject(project));
        }
    }

    private static class FetchForProject
    implements BuildAction<ProjectPublications> {
        private final BasicGradleProject project;

        public FetchForProject(BasicGradleProject project) {
            this.project = project;
        }

        public ProjectPublications execute(BuildController controller) {
            return (ProjectPublications)controller.findModel((Model)this.project, ProjectPublications.class);
        }
    }
}

