/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.DefaultBuildContext;
import org.gradle.profiler.Phase;
import org.gradle.profiler.ScenarioContext;

public class DefaultScenarioContext
implements ScenarioContext {
    private final UUID invocationId;
    private final String scenarioName;

    @VisibleForTesting
    public DefaultScenarioContext(UUID invocationId, String scenarioName) {
        this.invocationId = invocationId;
        this.scenarioName = scenarioName;
    }

    @Override
    public String getUniqueScenarioId() {
        return String.format("_%s_%s", this.invocationId.toString().replaceAll("-", "_"), DefaultScenarioContext.mangleName(this.scenarioName));
    }

    @Override
    public BuildContext withBuild(Phase phase, int count) {
        return new DefaultBuildContext(this, phase, count);
    }

    private static String mangleName(String scenarioName) {
        StringBuilder name = new StringBuilder();
        for (char ch : scenarioName.toCharArray()) {
            name.append(Character.isJavaIdentifierPart(ch) ? ch : (char)'_');
        }
        name.append('_');
        name.append(Hashing.murmur3_32().hashString((CharSequence)scenarioName, StandardCharsets.UTF_8));
        return name.toString();
    }
}

