/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.io.File;
import java.io.PrintStream;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.profiler.BuildConfiguration;
import org.gradle.profiler.BuildInvoker;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.InvocationSettings;

public abstract class ScenarioDefinition {
    private final String name;
    private final String title;
    private final List<BuildMutator> buildMutators;
    private final int warmUpCount;
    private final int buildCount;
    private final File outputDir;

    public ScenarioDefinition(String name, @Nullable String title, List<BuildMutator> buildMutators, int warmUpCount, int buildCount, File outputDir) {
        this.name = name;
        this.title = title;
        this.buildMutators = buildMutators;
        this.warmUpCount = warmUpCount;
        this.buildCount = buildCount;
        this.outputDir = outputDir;
    }

    public void validate() {
        for (BuildMutator buildMutator : this.buildMutators) {
            try {
                buildMutator.validate(this.getInvoker());
            }
            catch (Exception ex) {
                throw new IllegalStateException("Scenario '" + this.getTitle() + "' is invalid: " + ex.getMessage(), ex);
            }
        }
    }

    public String getTitle() {
        return this.title != null ? this.title : this.name;
    }

    public abstract String getDisplayName();

    public abstract String getProfileName();

    public abstract String getBuildToolDisplayName();

    public abstract String getTasksDisplayName();

    public abstract BuildInvoker getInvoker();

    public String getName() {
        return this.name;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public List<BuildMutator> getBuildMutators() {
        return this.buildMutators;
    }

    public int getWarmUpCount() {
        return this.warmUpCount;
    }

    public int getBuildCount() {
        return this.buildCount;
    }

    public void printTo(PrintStream out) {
        out.println("Scenario: " + this.getDisplayName());
        this.printDetail(out);
        out.println("  Build changes: " + this.getBuildMutators());
        out.println("  Warm-ups: " + this.getWarmUpCount());
        out.println("  Builds: " + this.getBuildCount());
    }

    public void visitProblems(InvocationSettings settings, Consumer<String> reporter) {
    }

    protected void printDetail(PrintStream out) {
    }

    public abstract boolean createsMultipleProcesses();

    public abstract boolean doesCleanup();

    public abstract BuildConfiguration getBuildConfiguration();
}

