/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.mutations.AbstractCleanupMutator;

public class ClearGradleUserHomeMutator
extends AbstractCleanupMutator {
    private final File gradleUserHome;

    public ClearGradleUserHomeMutator(File gradleUserHome, AbstractCleanupMutator.CleanupSchedule schedule) {
        super(schedule);
        this.gradleUserHome = gradleUserHome;
    }

    @Override
    protected void cleanup() {
        System.out.println(String.format("> Cleaning Gradle user home: %s", this.gradleUserHome.getAbsolutePath()));
        if (!this.gradleUserHome.exists()) {
            throw new IllegalArgumentException(String.format("Cannot delete Gradle user home directory (%s) since it does not exist", this.gradleUserHome));
        }
        try {
            Files.list(this.gradleUserHome.toPath()).filter(path -> !path.getFileName().toString().equals("wrapper")).forEach(path -> ClearGradleUserHomeMutator.delete(path.toFile()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class Configurator
    extends AbstractCleanupMutator.Configurator {
        @Override
        protected BuildMutator newInstance(Config scenario, String scenarioName, InvocationSettings settings, String key, AbstractCleanupMutator.CleanupSchedule schedule) {
            return new ClearGradleUserHomeMutator(settings.getGradleUserHome(), schedule);
        }
    }
}

