/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.commons.io.FileUtils;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.mutations.AbstractCleanupMutator;

public class ClearProjectCacheMutator
extends AbstractCleanupMutator {
    private final File projectDir;

    public ClearProjectCacheMutator(File projectDir, AbstractCleanupMutator.CleanupSchedule schedule) {
        super(schedule);
        this.projectDir = projectDir;
    }

    @Override
    protected void cleanup() {
        this.deleteGradleCache("project", this.projectDir);
        File buildSrc = new File(this.projectDir, "buildSrc");
        if (buildSrc.exists()) {
            this.deleteGradleCache("buildSrc", buildSrc);
        }
    }

    private void deleteGradleCache(String name, File baseDir) {
        File gradleCache = new File(baseDir, ".gradle");
        System.out.println(String.format("> Cleaning %s .gradle cache: %s", name, gradleCache));
        try {
            FileUtils.deleteDirectory((File)gradleCache);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class Configurator
    extends AbstractCleanupMutator.Configurator {
        @Override
        protected BuildMutator newInstance(Config scenario, String scenarioName, InvocationSettings settings, String key, AbstractCleanupMutator.CleanupSchedule schedule) {
            return new ClearProjectCacheMutator(settings.getProjectDir(), schedule);
        }
    }
}

