/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.buildscan;

import java.io.PrintWriter;
import org.gradle.profiler.GeneratedInitScript;

public class GradleEnterpriseInitScript
extends GeneratedInitScript {
    static final String PUBLISH_AND_TAG = "        if (System.getProperty('org.gradle.profiler.phase') == 'MEASURE') {\n            publishAlways()\n        }\n        tag('GRADLE_PROFILER')\n";
    private final String version;

    public GradleEnterpriseInitScript(String version) {
        this.version = version;
    }

    @Override
    public void writeContents(PrintWriter writer) {
        writer.write("initscript {\n");
        writer.write("    repositories {\n");
        writer.write("      gradlePluginPortal()\n");
        writer.write("    }\n");
        writer.write("    dependencies {\n");
        writer.write("        classpath(\"com.gradle:gradle-enterprise-gradle-plugin:" + this.version + "\")\n");
        writer.write("    }\n");
        writer.write("}\n");
        writer.write("\n");
        writer.write("settingsEvaluated {\n");
        writer.write("    if (!it.pluginManager.hasPlugin(\"com.gradle.enterprise\")) {\n");
        writer.write("        it.pluginManager.apply(com.gradle.enterprise.gradleplugin.GradleEnterprisePlugin)\n");
        writer.write("    }\n");
        writer.write("    it.extensions[\"gradleEnterprise\"].buildScan.with {\n");
        writer.write("        termsOfServiceUrl = 'https://gradle.com/terms-of-service'\n");
        writer.write("        termsOfServiceAgree = 'yes'\n");
        writer.write(PUBLISH_AND_TAG);
        writer.write("    }\n");
        writer.write("}\n");
    }
}

