/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.flamegraph;

import java.io.File;
import java.util.Locale;
import org.gradle.profiler.flamegraph.DetailLevel;
import org.gradle.profiler.flamegraph.EventType;

public class Stacks {
    public static final String STACKS_FILE_SUFFIX = "-stacks.txt";
    private final File file;
    private final EventType type;
    private final DetailLevel level;
    private final String fileBaseName;
    private final boolean negate;

    public static String postFixFor(EventType type, DetailLevel level) {
        return "-" + type.getId() + "-" + level.name().toLowerCase(Locale.ROOT);
    }

    public Stacks(File file, EventType type, DetailLevel level, String fileBaseName) {
        this(file, type, level, fileBaseName, false);
    }

    public Stacks(File file, EventType type, DetailLevel level, String fileBaseName, boolean negate) {
        this.file = file;
        this.type = type;
        this.level = level;
        this.fileBaseName = fileBaseName;
        this.negate = negate;
    }

    public File getFile() {
        return this.file;
    }

    public EventType getType() {
        return this.type;
    }

    public DetailLevel getLevel() {
        return this.level;
    }

    public boolean isEmpty() {
        return this.file.length() == 0L;
    }

    public String getFileBaseName() {
        return this.fileBaseName;
    }

    public boolean isNegate() {
        return this.negate;
    }
}

