/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.studio.process;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import org.gradle.profiler.CommandExec;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.client.protocol.Server;
import org.gradle.profiler.client.protocol.ServerConnection;
import org.gradle.profiler.studio.launcher.StudioLauncher;
import org.gradle.profiler.studio.launcher.StudioLauncherProvider;
import org.gradle.profiler.studio.tools.StudioSandboxCreator;

public class StudioProcess
implements Closeable {
    private static final Duration STUDIO_START_TIMEOUT = Duration.ofSeconds(15L);
    private static final Duration PLUGIN_CONNECT_TIMEOUT = Duration.ofMinutes(1L);
    private static final Duration AGENT_CONNECT_TIMEOUT = Duration.ofMinutes(1L);
    private final Server studioAgentServer;
    private final Server studioPluginServer;
    private final StudioConnections connections;
    private final CommandExec.RunHandle process;

    public StudioProcess(Path studioInstallDir, StudioSandboxCreator.StudioSandbox sandbox, InvocationSettings invocationSettings, List<String> studioJvmArgs, List<String> ideaProperties) {
        Server studioStartDetectorServer = new Server("start-detector");
        this.studioPluginServer = new Server("plugin");
        this.studioAgentServer = new Server("agent");
        StudioLauncher studioLauncher = new StudioLauncherProvider(studioInstallDir, sandbox, studioJvmArgs, ideaProperties).withStudioPluginParameters(studioStartDetectorServer.getPort(), this.studioPluginServer.getPort()).withStudioAgentParameters(this.studioAgentServer.getPort()).get();
        this.process = studioLauncher.launchStudio(invocationSettings.getProjectDir());
        this.waitOnSuccessfulIdeStart(this.process, studioStartDetectorServer);
        this.connections = new StudioConnections(this.studioPluginServer.waitForIncoming(PLUGIN_CONNECT_TIMEOUT), this.studioAgentServer.waitForIncoming(AGENT_CONNECT_TIMEOUT));
    }

    private void waitOnSuccessfulIdeStart(CommandExec.RunHandle runHandle, Server studioStartDetectorServer) {
        try (Server server = studioStartDetectorServer;){
            server.waitForIncoming(STUDIO_START_TIMEOUT);
        }
        catch (Exception e) {
            System.err.println("\n* ERROR\n* Could not connect to Android Studio process started by the gradle-profiler.\n* This might indicate that you are already running an Android Studio process in the same sandbox.\n* Stop Android Studio manually in the used sandbox or use a different sandbox with --studio-sandbox-dir to isolate the process.\n");
            this.kill(runHandle);
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public StudioConnections getConnections() {
        return this.connections;
    }

    private void kill(CommandExec.RunHandle runHandle) {
        try {
            this.disconnect();
        }
        catch (Exception exception) {
        }
        finally {
            runHandle.kill();
        }
    }

    private void disconnect() throws IOException {
        this.studioAgentServer.close();
        this.studioPluginServer.close();
    }

    @Override
    public void close() throws IOException {
        this.disconnect();
        this.process.waitForSuccess();
    }

    public static class StudioConnections {
        private final ServerConnection pluginConnection;
        private final ServerConnection agentConnection;

        public StudioConnections(ServerConnection pluginConnection, ServerConnection agentConnection) {
            this.pluginConnection = pluginConnection;
            this.agentConnection = agentConnection;
        }

        public ServerConnection getPluginConnection() {
            return this.pluginConnection;
        }

        public ServerConnection getAgentConnection() {
            return this.agentConnection;
        }
    }
}

