/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.gradle.profiler.TeeOutputStream;

public class Logging {
    private static PrintStream originalStdOut = System.out;
    private static PrintStream originalStdErr = System.err;
    private static PrintStream detail = System.out;
    private static OutputStream log;

    public static void resetLogging() throws IOException {
        if (System.out != originalStdOut) {
            System.out.flush();
            System.setOut(originalStdOut);
            detail = originalStdOut;
        }
        if (System.err != originalStdErr) {
            System.err.flush();
            System.setErr(originalStdErr);
        }
        if (log != null) {
            log.close();
            log = null;
        }
    }

    public static void setupLogging(File outputDir) throws IOException {
        outputDir.mkdirs();
        File logFile = new File(outputDir, "profile.log");
        log = new BufferedOutputStream(new FileOutputStream(logFile));
        detail = new PrintStream(log, true);
        PrintStream output = new PrintStream(new TeeOutputStream(System.out, detail));
        System.setOut(output);
        System.setErr(output);
    }

    public static PrintStream detailed() {
        return detail;
    }

    public static void startOperation(String name) {
        System.out.println();
        System.out.println("* " + name);
    }
}

