/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.flamegraph;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.gradle.profiler.flamegraph.DetailLevel;
import org.gradle.profiler.flamegraph.EventType;
import org.gradle.profiler.flamegraph.FlameGraphSanitizer;
import org.gradle.profiler.flamegraph.Stacks;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.ItemToolkit;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.JfrLoaderToolkit;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceFormatToolkit;

public class JfrToStacksConverter {
    private final Map<DetailLevel, FlameGraphSanitizer> sanitizers;

    public JfrToStacksConverter(Map<DetailLevel, FlameGraphSanitizer> sanitizers) {
        this.sanitizers = sanitizers;
    }

    public List<Stacks> generateStacks(File jfrFile, String outputBaseName) {
        Stream<File> jfrFiles = jfrFile.isDirectory() ? Stream.of((Object[])Objects.requireNonNull(jfrFile.listFiles((dir, name) -> name.endsWith(".jfr")))) : Stream.of(jfrFile);
        List<IItemCollection> recordings = jfrFiles.map(file -> {
            try {
                return JfrLoaderToolkit.loadEvents((File)file);
            }
            catch (IOException | CouldNotLoadRecordingException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        ArrayList<Stacks> stacks = new ArrayList<Stacks>();
        try {
            for (EventType type : EventType.values()) {
                for (DetailLevel level : DetailLevel.values()) {
                    String eventFileBaseName = outputBaseName + Stacks.postFixFor(type, level);
                    File stacksFile = this.generateStacks(jfrFile.getParentFile(), eventFileBaseName, recordings, type, level);
                    if (stacksFile == null) continue;
                    stacks.add(new Stacks(stacksFile, type, level, eventFileBaseName));
                }
            }
            return stacks;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private File generateStacks(File baseDir, String eventFileBaseName, List<IItemCollection> recordings, EventType type, DetailLevel level) throws IOException {
        File stacks = File.createTempFile("stacks", ".txt");
        this.convertToStacks(recordings, stacks, new Options(type, level.isShowArguments(), level.isShowLineNumbers()));
        if (stacks.length() == 0L) {
            stacks.delete();
            return null;
        }
        File sanitizedStacks = new File(baseDir, eventFileBaseName + "-stacks.txt");
        this.sanitizers.get((Object)level).sanitize(stacks, sanitizedStacks);
        stacks.delete();
        return sanitizedStacks;
    }

    private void convertToStacks(List<IItemCollection> recordings, File targetFile, Options options) {
        Map<String, Long> foldedStacks = this.foldStacks(recordings, options);
        this.writeFoldedStacks(foldedStacks, targetFile);
    }

    private Map<String, Long> foldStacks(List<IItemCollection> recordings, Options options) {
        StackFolder folder = new StackFolder(options);
        recordings.stream().flatMap(recording -> StreamSupport.stream(recording.spliterator(), false)).flatMap(eventStream -> StreamSupport.stream(eventStream.spliterator(), false)).filter(options.eventType::matches).filter(event -> JfrToStacksConverter.getStackTrace(event) != null).forEach(folder);
        return folder.getFoldedStacks();
    }

    private void writeFoldedStacks(Map<String, Long> foldedStacks, File targetFile) {
        targetFile.getParentFile().mkdirs();
        try (BufferedWriter writer = Files.newBufferedWriter(targetFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            for (Map.Entry<String, Long> entry : foldedStacks.entrySet()) {
                writer.write(String.format("%s %d%n", entry.getKey(), entry.getValue()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static IMCStackTrace getStackTrace(IItem event) {
        return (IMCStackTrace)ItemToolkit.getItemType((IItem)event).getAccessor(JfrAttributes.EVENT_STACKTRACE.getKey()).getMember((Object)event);
    }

    public static class Options {
        private final EventType eventType;
        private final boolean showArguments;
        private final boolean showLineNumbers;

        public Options(EventType eventType, boolean showArguments, boolean showLineNumbers) {
            this.eventType = eventType;
            this.showArguments = showArguments;
            this.showLineNumbers = showLineNumbers;
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public boolean isShowArguments() {
            return this.showArguments;
        }

        public boolean isShowLineNumbers() {
            return this.showLineNumbers;
        }
    }

    private static class StackFolder
    implements Consumer<IItem> {
        private final Options options;
        private final Map<String, Long> foldedStacks = new LinkedHashMap<String, Long>();

        public StackFolder(Options options) {
            this.options = options;
        }

        @Override
        public void accept(IItem event) {
            String stack = this.toStack(event);
            Long sum = this.foldedStacks.get(stack);
            long value = this.getValue(event);
            sum = sum == null ? Long.valueOf(value) : Long.valueOf(sum + value);
            this.foldedStacks.put(stack, sum);
        }

        private String toStack(IItem event) {
            IMCStackTrace stackTrace = JfrToStacksConverter.getStackTrace(event);
            ArrayList reverseStacks = new ArrayList(stackTrace.getFrames());
            Collections.reverse(reverseStacks);
            return reverseStacks.stream().map(this::frameName).collect(Collectors.joining(";"));
        }

        private String frameName(IMCFrame frame) {
            String frameName = StacktraceFormatToolkit.formatFrame((IMCFrame)frame, (FrameSeparator)new FrameSeparator(this.options.isShowLineNumbers() ? FrameSeparator.FrameCategorization.LINE : FrameSeparator.FrameCategorization.METHOD, false), (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)this.options.isShowArguments(), (boolean)true);
            return frame.getType() == IMCFrame.Type.UNKNOWN ? frameName : frameName + "_[j]";
        }

        private long getValue(IItem event) {
            return this.options.getEventType().getValue(event);
        }

        public Map<String, Long> getFoldedStacks() {
            return this.foldedStacks;
        }
    }
}

