/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.gradle.profiler.CommandExec;
import org.gradle.profiler.GradleBuildConfiguration;
import org.gradle.profiler.GradleClient;
import org.gradle.profiler.Logging;
import org.gradle.profiler.gradle.GradleInvoker;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;

public class CliGradleClient
implements GradleInvoker,
GradleClient {
    private final GradleBuildConfiguration gradleBuildConfiguration;
    private final File javaHome;
    private final File projectDir;
    private final boolean daemon;
    private final File buildLog;

    public CliGradleClient(GradleBuildConfiguration gradleBuildConfiguration, File javaHome, File projectDir, boolean daemon, File buildLog) {
        this.gradleBuildConfiguration = gradleBuildConfiguration;
        this.javaHome = javaHome;
        this.projectDir = projectDir;
        this.daemon = daemon;
        this.buildLog = buildLog;
    }

    @Override
    public void close() {
    }

    @Override
    public void loadToolingModel(List<String> tasks, List<String> gradleArgs, List<String> jvmArgs, Class<?> toolingModel) {
        throw new UnsupportedOperationException("Cannot fetch a tooling API model using the Gradle CLI.");
    }

    @Override
    public <T> T runToolingAction(List<String> tasks, List<String> gradleArgs, List<String> jvmArgs, BuildAction<T> action, Consumer<BuildActionExecuter<?>> configureAction) {
        throw new UnsupportedOperationException("Cannot run a tooling API action using the Gradle CLI.");
    }

    @Override
    public void runTasks(List<String> tasks, List<String> gradleArgs, List<String> jvmArgs) {
        String daemonJvmArgs = CliGradleClient.quoteJvmArguments(this.daemon, jvmArgs);
        ArrayList<String> commandLine = new ArrayList<String>();
        this.gradleBuildConfiguration.addGradleCommand(commandLine);
        commandLine.addAll(gradleArgs);
        commandLine.addAll(tasks);
        commandLine.add("-Dorg.gradle.daemon=" + this.daemon);
        if (!this.daemon) {
            commandLine.add("-Dorg.gradle.jvmargs");
        }
        ProcessBuilder builder = new ProcessBuilder(commandLine);
        builder.directory(this.projectDir);
        if (this.daemon) {
            String orgGradleJvmArgs = jvmArgs.isEmpty() ? "" : " \"-Dorg.gradle.jvmargs=" + daemonJvmArgs + "\"";
            LinkedHashSet<String> gradleOptsSet = new LinkedHashSet<String>();
            gradleOptsSet.add("-XX:+HeapDumpOnOutOfMemoryError");
            gradleOptsSet.addAll(this.gradleBuildConfiguration.getClientJvmArguments());
            builder.environment().put("GRADLE_OPTS", CliGradleClient.quoteJvmArguments(false, gradleOptsSet) + orgGradleJvmArgs);
        } else {
            Logging.detailed().println("GRADLE_OPTS: " + daemonJvmArgs);
            builder.environment().put("GRADLE_OPTS", daemonJvmArgs);
        }
        Logging.detailed().println("JAVA_HOME: " + this.javaHome.getAbsolutePath());
        builder.environment().put("JAVA_HOME", this.javaHome.getAbsolutePath());
        builder.redirectErrorStream(true);
        try {
            if (this.buildLog == null) {
                new CommandExec().run(builder);
            } else {
                new CommandExec().runAndCollectOutput(this.buildLog, builder);
            }
        }
        catch (Exception e) {
            System.out.println();
            System.out.println("ERROR: failed to run build. See log file for details.");
            System.out.println();
            throw new RuntimeException("Build failed.", e);
        }
    }

    private static String quoteJvmArguments(boolean forSystemProperty, Collection<String> jvmArgs) {
        char quotes = forSystemProperty ? (char)'\'' : '\"';
        return jvmArgs.stream().peek(arg -> {
            if (arg.contains("\"") || arg.contains("'")) {
                throw new IllegalArgumentException("jvmArgs must not contain quotes, but this argument does: " + arg);
            }
        }).map(arg -> quotes + arg + quotes).collect(Collectors.joining(" "));
    }
}

