/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import com.typesafe.config.Config;
import java.io.File;
import org.gradle.profiler.BuildContext;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.CommandExec;
import org.gradle.profiler.ConfigUtil;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.ScenarioContext;
import org.gradle.profiler.mutations.AbstractGitMutator;
import org.gradle.profiler.mutations.BuildMutatorConfigurator;

public class GitCheckoutMutator
extends AbstractGitMutator {
    private final String cleanup;
    private final String build;
    private String original;

    public GitCheckoutMutator(File projectDir, String cleanup, String build) {
        super(projectDir);
        this.cleanup = cleanup;
        this.build = build;
    }

    @Override
    public void beforeScenario(ScenarioContext context) {
        this.resetGit();
        this.original = this.getCurrentCommit();
    }

    @Override
    public void beforeCleanup(BuildContext context) {
        if (this.cleanup != null) {
            this.checkout(this.cleanup);
        }
    }

    @Override
    public void beforeBuild(BuildContext context) {
        if (this.build != null) {
            this.checkout(this.build);
        }
    }

    @Override
    public void afterBuild(BuildContext context, Throwable error) {
        if (error == null) {
            this.checkout(this.original);
        } else {
            System.out.println("> Not checking out original Git commit because of error during build");
        }
    }

    private String getCurrentCommit() {
        return new CommandExec().inDir(this.projectDir).runAndCollectOutput("git", "rev-parse", "HEAD").trim();
    }

    private void checkout(String target) {
        System.out.println("> Checking out " + target);
        new CommandExec().inDir(this.projectDir).run("git", "checkout", target);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(cleanup: " + this.cleanup + ", build: " + this.build + ")";
    }

    public static class Configurator
    implements BuildMutatorConfigurator {
        @Override
        public BuildMutator configure(String key, BuildMutatorConfigurator.BuildMutatorConfiguratorSpec spec) {
            Config config = spec.getScenario().getConfig(key);
            String cleanup = ConfigUtil.string(config, "cleanup", null);
            String build = ConfigUtil.string(config, "build", null);
            if (build == null) {
                throw new IllegalArgumentException("No git-checkout target specified for build");
            }
            InvocationSettings settings = spec.getInvocationSettings();
            return new GitCheckoutMutator(settings.getProjectDir(), cleanup, build);
        }
    }
}

