/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.report;

import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.report.AbstractGenerator;
import org.gradle.profiler.report.BenchmarkResult;
import org.gradle.profiler.report.JsonResultWriter;

public class HtmlGenerator
extends AbstractGenerator {
    private static final String JSON_PLACEHOLDER = "@@BENCHMARK_RESULT_JSON@@";
    private static final String SCRIPT_PLACEHOLDER = "@@SCRIPT@@";

    public HtmlGenerator(File outputFile) {
        super(outputFile);
    }

    @Override
    protected void write(final InvocationSettings settings, final BenchmarkResult benchmarkResult, final BufferedWriter writer) throws IOException {
        Resources.readLines((URL)Resources.getResource(HtmlGenerator.class, (String)"report-template.html"), (Charset)StandardCharsets.UTF_8, (LineProcessor)new LineProcessor<Void>(){

            public boolean processLine(String line) throws IOException {
                if (line.equals(HtmlGenerator.SCRIPT_PLACEHOLDER)) {
                    Resources.asCharSource((URL)Resources.getResource(HtmlGenerator.class, (String)"report.js"), (Charset)StandardCharsets.UTF_8).copyTo((Appendable)writer);
                } else if (line.equals(HtmlGenerator.JSON_PLACEHOLDER)) {
                    new JsonResultWriter(true).write(settings.getBenchmarkTitle(), Instant.now(), benchmarkResult.getScenarios(), writer);
                } else {
                    writer.write(line);
                }
                writer.write("\n");
                return true;
            }

            public Void getResult() {
                return null;
            }
        });
    }
}

