/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.flamegraph;

import com.google.common.base.Joiner;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.gradle.profiler.flamegraph.DetailLevel;
import org.gradle.profiler.flamegraph.EventType;
import org.gradle.profiler.flamegraph.Stacks;

public class DifferentialStacksGenerator {
    public List<Stacks> generateDifferentialStacks(File baseOutputDir) throws IOException {
        ArrayList<Stacks> stacks = new ArrayList<Stacks>();
        try (Stream<Path> list = Files.list(baseOutputDir.toPath());){
            List<Path> experiments = list.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
            experiments.forEach(experiment -> experiments.stream().filter(it -> !experiment.equals(it)).forEach(baseline -> {
                for (EventType type : EventType.values()) {
                    Stacks forwardDiff;
                    DetailLevel level = DetailLevel.SIMPLIFIED;
                    Stacks backwardDiff = this.generateDiff(experiment.toFile(), baseline.toFile(), type, level, false);
                    if (backwardDiff != null) {
                        stacks.add(backwardDiff);
                    }
                    if ((forwardDiff = this.generateDiff(experiment.toFile(), baseline.toFile(), type, level, true)) == null) continue;
                    stacks.add(forwardDiff);
                }
            }));
        }
        return stacks;
    }

    private Stacks generateDiff(File versionUnderTest, File baseline, EventType type, DetailLevel level, boolean negate) {
        File underTestStacks = DifferentialStacksGenerator.stacksFileName(versionUnderTest, type, level);
        File baselineStacks = DifferentialStacksGenerator.stacksFileName(baseline, type, level);
        if (underTestStacks != null && baselineStacks != null) {
            String underTestBasename = DifferentialStacksGenerator.stacksBasename(underTestStacks, type, level);
            String baselineTestBasename = DifferentialStacksGenerator.stacksBasename(baselineStacks, type, level);
            String differentNamePart = this.computeDifferenceOfBaselineToCurrentName(underTestBasename, baselineTestBasename);
            String diffBaseName = underTestBasename + "-vs-" + differentNamePart + Stacks.postFixFor(type, level) + "-" + (negate ? "forward-" : "backward-") + "diff";
            File diff = new File(underTestStacks.getParentFile(), "diffs/" + diffBaseName + "-stacks.txt");
            diff.getParentFile().mkdirs();
            if (negate) {
                this.generateDiff(underTestStacks, baselineStacks, diff);
            } else {
                this.generateDiff(baselineStacks, underTestStacks, diff);
            }
            return new Stacks(diff, type, level, diffBaseName, negate);
        }
        return null;
    }

    public void generateDiff(File versionUnderTest, File baseline, File diff) {
        try {
            Map<String, Long> parsedUnderTestStacks = this.readStacks(versionUnderTest);
            Map<String, Long> parsedBaselineStacks = this.readStacks(baseline);
            try (BufferedWriter writer = Files.newBufferedWriter(diff.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                this.generateDiff(parsedUnderTestStacks, parsedBaselineStacks, (String stackLine) -> {
                    try {
                        writer.write((String)stackLine);
                        writer.newLine();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
        }
        catch (Exception e) {
            System.err.printf("Problem while creating differential stack file %s: %s%n", diff, e.getMessage());
        }
    }

    private Map<String, Long> readStacks(File file) throws IOException {
        try (Stream<String> lines = Files.lines(file.toPath(), StandardCharsets.UTF_8);){
            LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
            lines.forEach(line -> {
                if (line.isEmpty()) {
                    return;
                }
                int lastSpace = line.lastIndexOf(" ");
                if (lastSpace == -1) {
                    return;
                }
                String stack = line.substring(0, lastSpace).trim();
                long count = Long.parseLong(line.substring(lastSpace + 1));
                result.compute(stack, (s, c) -> c == null ? count : c + count);
            });
            LinkedHashMap<String, Long> linkedHashMap = result;
            return linkedHashMap;
        }
    }

    private void generateDiff(Map<String, Long> from, Map<String, Long> to, Consumer<String> stackConsumer) {
        HashSet<String> allStacks = new HashSet<String>();
        allStacks.addAll(from.keySet());
        allStacks.addAll(to.keySet());
        for (String stack : allStacks) {
            long countFrom = from.getOrDefault(stack, 0L);
            long countTo = to.getOrDefault(stack, 0L);
            stackConsumer.accept(stack + " " + countFrom + " " + countTo);
        }
    }

    private String computeDifferenceOfBaselineToCurrentName(String underTestBasename, String baselineTestBasename) {
        List<String> underTestParts = Arrays.asList(underTestBasename.split("-"));
        ArrayDeque<String> remainderOfBaseline = new ArrayDeque<String>(Arrays.asList(baselineTestBasename.split("-")));
        for (String underTestPart : underTestParts) {
            if (remainderOfBaseline.isEmpty() || !underTestPart.equals(remainderOfBaseline.getFirst())) break;
            remainderOfBaseline.removeFirst();
        }
        Collections.reverse(underTestParts);
        for (String underTestPart : underTestParts) {
            if (remainderOfBaseline.isEmpty() || !underTestPart.equals(remainderOfBaseline.getLast())) break;
            remainderOfBaseline.removeLast();
        }
        return Joiner.on((String)"-").join(remainderOfBaseline);
    }

    private static String stacksBasename(File underTestStacks, EventType type, DetailLevel level) {
        String postfix = Stacks.postFixFor(type, level) + "-stacks.txt";
        String underTestStacksName = underTestStacks.getName();
        if (!underTestStacksName.endsWith(postfix)) {
            throw new RuntimeException("Stacks file '" + underTestStacks.getAbsolutePath() + "' doesn't follow the naming convention and does not end with " + postfix);
        }
        return underTestStacksName.substring(0, underTestStacksName.length() - postfix.length());
    }

    @Nullable
    private static File stacksFileName(File baseDir, EventType type, DetailLevel level) {
        String suffix = Stacks.postFixFor(type, level) + "-stacks.txt";
        File[] stackFiles = baseDir.listFiles((dir, name) -> name.endsWith(suffix));
        if (stackFiles == null || stackFiles.length == 0) {
            return null;
        }
        if (stackFiles.length == 1) {
            return stackFiles[0];
        }
        throw new RuntimeException("More than one matching stacks file found: " + Arrays.asList(stackFiles));
    }
}

