/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.studio.process;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.client.protocol.messages.Message;
import org.gradle.profiler.client.protocol.messages.StudioAgentConnectionParameters;
import org.gradle.profiler.studio.invoker.StudioGradleScenarioDefinition;
import org.gradle.profiler.studio.process.StudioProcess;
import org.gradle.profiler.studio.tools.StudioSandboxCreator;

public class StudioProcessController {
    private final Path studioInstallDir;
    private final StudioSandboxCreator.StudioSandbox sandbox;
    private final InvocationSettings invocationSettings;
    private final StudioGradleScenarioDefinition.StudioGradleBuildConfiguration buildConfiguration;
    private StudioProcess process;

    public StudioProcessController(Path studioInstallDir, StudioSandboxCreator.StudioSandbox sandbox, InvocationSettings invocationSettings, StudioGradleScenarioDefinition.StudioGradleBuildConfiguration buildConfiguration) {
        this.studioInstallDir = studioInstallDir;
        this.sandbox = sandbox;
        this.invocationSettings = invocationSettings;
        this.buildConfiguration = buildConfiguration;
    }

    public <R> R run(Function<StudioProcess.StudioConnections, R> action) {
        return this.run(this.maybeStartProcess(), action);
    }

    public void runAndWaitToStop(Consumer<StudioProcess.StudioConnections> action) {
        try (StudioProcess process = this.maybeStartProcess();){
            this.run(process, connections -> {
                action.accept((StudioProcess.StudioConnections)connections);
                return null;
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.process = null;
        }
    }

    private <R> R run(StudioProcess process, Function<StudioProcess.StudioConnections, R> action) {
        return action.apply(process.getConnections());
    }

    public boolean isProcessRunning() {
        return this.process != null;
    }

    public StudioProcess maybeStartProcess() {
        if (!this.isProcessRunning()) {
            this.process = new StudioProcess(this.studioInstallDir, this.sandbox, this.invocationSettings, this.buildConfiguration.getStudioJvmArgs(), this.buildConfiguration.getIdeaProperties());
            this.process.getConnections().getAgentConnection().send((Message)new StudioAgentConnectionParameters(this.buildConfiguration.getGradleHome()));
        }
        return this.process;
    }
}

