/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.gradle.profiler.BuildScenarioResultImpl;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.ScenarioDefinition;
import org.gradle.profiler.report.AbstractGenerator;
import org.gradle.profiler.report.BenchmarkResult;
import org.gradle.profiler.report.BuildScenarioResult;
import org.gradle.profiler.result.BuildInvocationResult;
import org.gradle.profiler.result.SampleProvider;

public class BenchmarkResultCollector {
    private final List<BuildScenarioResultImpl<?>> allBuilds = new ArrayList();
    private final List<AbstractGenerator> generators;

    public BenchmarkResultCollector(AbstractGenerator ... generators) {
        this.generators = Arrays.asList(generators);
    }

    public <S extends ScenarioDefinition, T extends BuildInvocationResult> Consumer<T> scenario(S scenario, SampleProvider<T> sampleProvider) {
        BuildScenarioResultImpl<T> buildScenario = new BuildScenarioResultImpl<T>(scenario, sampleProvider);
        this.allBuilds.add(buildScenario);
        return buildScenario;
    }

    public void write(InvocationSettings settings) throws IOException {
        for (AbstractGenerator generator : this.generators) {
            generator.write(settings, new BenchmarkResultImpl());
        }
    }

    public void summarizeResults(Consumer<String> consumer) {
        for (AbstractGenerator generator : this.generators) {
            generator.summarizeResults(consumer);
        }
    }

    private class BenchmarkResultImpl
    implements BenchmarkResult {
        private BenchmarkResultImpl() {
        }

        @Override
        public List<? extends BuildScenarioResult<?>> getScenarios() {
            return BenchmarkResultCollector.this.allBuilds;
        }
    }
}

