(function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r})()({1:[function(require,module,exports){
// Mann-Whitney U test
// Luke Mitchell, April 2016
// https://github.com/lukem512/mann-whitney-utest

// The object key used to store the observation value.
var __key = 'val';

// Rank the list.
// Inspired by https://gist.github.com/gungorbudak/1c3989cc26b9567c6e50
var rank = function(list) {

	// First, sort in ascending order
	list.sort(function(a, b) {
		return (a[__key] - b[__key]);
	});

	// Second, add the rank to the objects
	list = list.map(function(item, index) {
		item.rank = index + 1;
		return item;
	});

	// Third, use median values for groups with the same rank
	for (var i = 0; i < list.length; /* nothing */ ) {
		var count = 1;
		var total = list[i].rank;

		for (var j = 0; list[i + j + 1] && (list[i + j][__key] === list[i + j + 1][__key]); j++) {
			total += list[i + j + 1].rank;
			count++;
		}

		var rank = (total / count);

		for (var k = 0; k < count; k++) {
			list[i + k].rank = rank;
		}

		i = i + count;
	}

	return list;
};

// Compute the rank of a sample, given a ranked
// list and a list of observations for that sample.
var sampleRank = function(rankedList, observations) {

	// Clone the array
	var __observations = observations.slice(0);

	// Compute the rank
	var rank = 0;
	rankedList.forEach(function(observation) {
		var index = __observations.indexOf(observation[__key]);
		if (index > -1) {
			// Add the rank to the sum
			rank += observation.rank;

			// Remove the observation from the list
    		__observations.splice(index, 1);
		}
	});

	return rank;
};

// Compute the U value of a sample,
// given the rank and the list of observations
// for that sample.
var uValue = function(rank, observations) {
	var k = observations.length;
	return rank - ((k * (k+1)) / 2);
};

// Check the U values are valid.
// This utilises a property of the Mann-Whitney U test
// that ensures the sum of the U values equals the product
// of the number of observations.
var check = module.exports.check = function(u, samples) {
	return (u[0] + u[1]) == (samples[0].length * samples[1].length);
};

// Approximate the crticial value for the samples.
// This is necessary when the sample sizes are greater than 20
// as the U tables are limited to 20x20.
// https://en.wikipedia.org/wiki/Mann%E2%80%93Whitney_U_test#Normal_approximation_and_tie_correction
var criticalValue = module.exports.criticalValue = function(u, samples) {
	var uVal = Math.min(u[0], u[1]);
	var prod = samples[0].length * samples[1].length;
	var n  = samples[0].length + samples[1].length;
	var mean = prod / 2;

	// Count the ranks
	var counts = {};
	samples.forEach(function(sample) {
		sample.forEach(function(o) {
			if (!counts[o]) counts[o] = 1;
			else counts[o]++;
		});
	});

	// Find any tied ranks
	var ties = Object.keys(counts)
		.filter(function(key) { return counts[key] > 1 })
		.map(function(tie) { return counts[tie] });
	var k = ties.length;

	// Compute correction
	var correction = 0;
	for (var i = 0; i < k; i++) {
		correction += (Math.pow(ties[i],3) - ties[i]) / (n * (n-1));
	}

	// Compute standard deviation using correction for ties
	var stddev = Math.sqrt(
		(prod/12) * ((n + 1) - correction)
	);

	// Approximate the critical value
	var z = Math.abs((uVal - mean) / stddev);
	return z;
};

// Test the result for significance.
// A result is significant if the lesser U-value is
// less than the critical value.
var significant = module.exports.significant = function(u, samples) {
	return (Math.min(u[0], u[1]) < criticalValue(u, samples));
};

// Perform te Mann-Whitney U test on an array of samples.
// The input should be of the form [[a, b, c], [e, f, g]]
// where {a, b, ..., g} are numeric values forming two
// samples.
var test = module.exports.test = function(samples, key) {

	// Perform validation
	if (!Array.isArray(samples)) throw Error('Samples must be an array');
	if (samples.length !== 2) throw Error('Samples must contain exactly two samples');

	for (var i = 0; i < 2; i++) {
		if (!samples[i] || samples[i].length == 0) throw Error('Samples cannot be empty');
		if (!Array.isArray(samples[i])) throw Error('Sample ' + i + ' must be an array');
	}

	// Rank the entire list of observations
	var all = samples[0].concat(samples[1]);

	var unranked = all.map(function(val) {
		var result = {};
		result[__key] = val;
		return result;
	});

	var ranked = rank(unranked);

	// Compute the rank of each sample
	var ranks = [];
	for (var i = 0; i < 2; i++) {
		ranks[i] = sampleRank(ranked, samples[i]);
	}

	// Compute the U values
	var us = [];
	for (var i = 0; i < 2; i++) {
		us[i] = uValue(ranks[i], samples[i]);
	}

	// An optimisation is to use a property of the U test
	// to calculate the U value of sample 1 based on the value
	// of sample 0
	// var u[1] = (samples[0].length * samples[1].length) - u[0];

	// Return the array of U values
	return us;
};

},{}],2:[function(require,module,exports){
mwu = require("mann-whitney-utest");

const Phase = {
    WARM_UP: "WARM_UP",
    MEASURE: "MEASURE"
};

Array.prototype.numericSort = function() {
    return this.slice().sort((a, b) => a - b);
}
Array.prototype.reverseNumericSort = function() {
    return this.slice().sort((a, b) => b - a);
}
Array.prototype.min = function() {
    return Math.min(...this);
}
Array.prototype.mean = function() {
    return this.reduce((sum, val) => sum + val) / this.length;
}
Array.prototype.max = function() {
    return Math.max(...this);
}
Array.prototype.quantile = function(q) {
    const sorted = this.numericSort();
    const pos = (sorted.length - 1) * q;
    const base = Math.floor(pos);
    const rest = pos - base;
    if (sorted[base + 1] !== undefined) {
        return sorted[base] + rest * (sorted[base + 1] - sorted[base]);
    } else {
        return sorted[base];
    }
}
Array.prototype.stddev = function() {
    const mean = this.mean();
    return Math.sqrt(this.map(x => Math.pow(x - mean, 2)).mean());
}
Array.prototype.unique = function() {
    return [...new Set(this)];
}
const dataFormat = new Intl.NumberFormat(navigator.language, { minimumFractionDigits: 2, maximumFractionDigits: 2 });
const labelFormat = new Intl.NumberFormat(navigator.language, { minimumFractionDigits: 0, maximumFractionDigits: 2 });
const dataDiffFormat = new Intl.NumberFormat(navigator.language, { minimumFractionDigits: 2, maximumFractionDigits: 2, signDisplay: "exceptZero" });
const percentFormat = new Intl.NumberFormat(navigator.language, { style: 'percent', minimumFractionDigits: 2, maximumFractionDigits: 2 });
const percentDiffFormat = new Intl.NumberFormat(navigator.language, { style: 'percent', minimumFractionDigits: 2, maximumFractionDigits: 2, signDisplay: "exceptZero"  });

function measuredIterations(scenario) {
    return scenario.iterations.filter(iteration => iteration.phase === Phase.MEASURE);
}

class Operation {
    constructor(name, title, calculator) {
        this.name = name;
        this.title = title;
        this.calculator = calculator;
    }

    apply(data) {
        return this.calculator(data);
    }
}

const OPERATIONS = module.exports.OPERATIONS = window.OPERATIONS = [
    new Operation("mean", "Mean", (data) => data.mean()),
    new Operation("min", "Min", (data) => data.min()),
    new Operation("p25", "P25", (data) => data.quantile(.25)),
    new Operation("median", "Median", (data) => data.quantile(.50)),
    new Operation("p75", "P75", (data) => data.quantile(.75)),
    new Operation("max", "Max", (data) => data.max()),
    new Operation("stddev", "Std.dev", (data) => data.stddev())
];

new Vue({
    el: '#app',
    data: {
        options: {
            sorted: false,
            showAll: true
        },
        benchmarkResult: benchmarkResult,
        operations: OPERATIONS,
        baseline: null
    },
    computed: {
        multipleBuildToolsPresent: function() {
            return this.benchmarkResult.scenarios.map(scenario => scenario.definition.buildTool).unique().length > 1;
        },
        chartData: function() {
            const sorted = this.options.sorted;
            const multipleBuildToolsPresent = this.multipleBuildToolsPresent;
            return this.benchmarkResult.scenarios
                .map(scenario => scenario.samples
                    .filter(sample => sample.selected)
                    .map(sample => {
                        let data = measuredIterations(scenario)
                            .map(iteration => iteration.values[sample.name]);
                        if (sorted) {
                            data = data.reverseNumericSort();
                        }
                        return {
                            label: multipleBuildToolsPresent
                                ? `${scenario.definition.title} ${scenario.definition.buildTool} (${sample.name})`
                                : `${scenario.definition.title} (${sample.name})`,
                            showLine: true,
                            stepped: "middle",
                            pointRadius: 0,
                            pointHitRadius: 10,
                            hoverRadius: 6,
                            fill: false,
                            borderWidth: sample.thickness,
                            backgroundColor: sample.color,
                            pointBackgroundColor: sample.color,
                            borderColor: sample.color,
                            data: data,
                            sample: sample,
                            yAxisID: sample.unit
                        };
                    }))
                .flat();
        }
    },
    watch: {
        "options.sorted": function() {
            this.updateData();
        }
    },
    methods: {
        select: function(sample) {
            sample.selected = !sample.selected;
            this.updateData();
        },
        toggleAll: function(selected) {
            benchmarkResult.scenarios.forEach(scenario => scenario.samples.forEach(sample => sample.selected = selected));
            this.updateData();
        },
        rowCount: function(scenario) {
            return scenario.samples.filter(sample => this.options.showAll || sample.selected).length;
        },
        updateData: function() {
            this.chart.data.datasets = this.chartData;
            this.chart.update();
        },
        uTest: function(scenario, baseline, sample) {
            const samples = [
                measuredIterations(baseline).map(iteration => iteration.values[sample.name]),
                measuredIterations(scenario).map(iteration => iteration.values[sample.name])
            ];
            const u = mwu.test(samples);
            const z = mwu.criticalValue(u, samples);
            return 0.5 * (1 + math.erf(z / math.sqrt(2)));
        }
    },
    filters: {
        "numeric": (value) => dataFormat.format(value),
        "diff": (value) => dataDiffFormat.format(value),
        "percent": (value) => isNaN(value) ? "" : percentFormat.format(value),
        "percentDiff": (value) => isNaN(value) ? "" : percentDiffFormat.format(value),
        "date": (value) => value.toLocaleString(navigator.language, {
            year: 'numeric', month: 'long', day: 'numeric',
            hour: 'numeric', minute: 'numeric', second: 'numeric',
           timeZoneName: 'short'
        })
    },
    beforeCreate: function() {
        // Initialize sample config
        benchmarkResult.scenarios.forEach((scenario, scenarioIndex, scenarios) => {
            scenario.showDetails = false;
            scenario.samples.forEach((sample, sampleIndex, samples) => {
                sample.color = `hsl(${scenarioIndex * 360 / scenarios.length}, ${100 - 80 * sampleIndex / samples.length}%, ${30 + 40 * sampleIndex / samples.length}%)`;
                sample.thickness = sampleIndex === 0 ? 3 : 2;
                sample.selected = sampleIndex === 0;
                const data = measuredIterations(scenario).map(iteration => iteration.values[sample.name]);
                OPERATIONS.forEach(operation => sample[operation.name] = operation.apply(data));
            });
        });
    },
    created: function() {
        // Set baseline for regression tests
        this.baseline = this.multipleBuildToolsPresent
            ? benchmarkResult.scenarios[0]
            : null;
    },
    mounted: function() {
        const ctx = document.getElementById('samples').getContext('2d');
        const maxMeasuredIterations = benchmarkResult.scenarios
            .map(scenario => measuredIterations(scenario).length)
            .max();
        const scales = benchmarkResult.scenarios
            .flatMap(scenario => scenario.samples)
            .map(sample => sample.unit)
            .unique()
            .reduce((scales, unit) => {
                scales[unit] = {
                    type: "linear",
                    display: "auto",
                    beginAtZero: true,
                    position: Object.keys(scales).length % 2 === 0
                        ? "left"
                        : "right",
                    ticks: {
                        callback: function(value, index, ticks) {
                            return labelFormat.format(value) + ' ' + unit;
                        }
                    }
                };
                return scales;
            }, {});
        Chart.defaults.font.family = "Lato";
        Chart.defaults.font.size = "14";
        const chart = this.chart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: Array.from(Array(maxMeasuredIterations), (_, i) => (i + 1).toString()),
                datasets: this.chartData
            },
            options: {
                plugins: {
                    legend: {
                        display: false
                    },
                    tooltip: {
                        mode: "index",
                        position: "average",
                        itemSort: (a, b) => b.yLabel - a.yLabel,
                        callbacks: {
                            title: (tooltips, data) => `Build #${tooltips[0].label}`,
                            label: (context) => dataFormat.format(context.parsed.y) + " " + context.dataset.sample.unit + " – " + context.dataset.label
                        }
                    }
                },
                animation: {
                    duration: 0
                },
                aspectRatio: 3,
                scales: scales
            }
        });
        document.fonts.ready.then(() => chart.update());
    }
});

},{"mann-whitney-utest":1}]},{},[2]);
