/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry.size;

import com.github.weisj.jsvg.D;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.google.errorprone.annotations.Immutable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@Immutable
public final class Length {
    public static final float UNSPECIFIED_RAW = Float.NaN;
    @NotNull
    public static final Length UNSPECIFIED = new Length(D.Raw, Float.NaN);
    @NotNull
    public static final Length ZERO = new Length(D.Raw, 0.0f);
    @NotNull
    private final D a;
    private final float b;

    /*
     * WARNING - void declaration
     */
    public Length(@NotNull D unit, float value) {
        void var2_2;
        void var1_1;
        this.a = var1_1;
        this.b = var2_2;
    }

    public static boolean isUnspecified(float value) {
        return Float.isNaN(value);
    }

    public static boolean isSpecified(float value) {
        return !Length.isUnspecified(value);
    }

    private float a(@NotNull MeasureContext measureContext) {
        if (this.isUnspecified()) {
            throw new IllegalStateException("Can't resolve size of unspecified length");
        }
        if (this.a == D.Raw) {
            return this.b;
        }
        assert (this.a != D.PERCENTAGE);
        switch (this.a) {
            case PX: {
                return this.b;
            }
            case IN: {
                return 96.0f * this.b;
            }
            case CM: {
                return 37.7856f * this.b;
            }
            case MM: {
                return 3.7785597f * this.b;
            }
            case PT: {
                return 1.3333334f * this.b;
            }
            case PC: {
                return 16.0f * this.b;
            }
            case EM: {
                return measureContext.c * this.b;
            }
            case REM: {
                return MeasureContext.a() * this.b;
            }
            case EX: {
                return measureContext.d * this.b;
            }
        }
        throw new UnsupportedOperationException("Not implemented: Can't convert " + String.valueOf((Object)this.a) + " to pixel");
    }

    /*
     * WARNING - void declaration
     */
    public final float resolveWidth(@NotNull MeasureContext context) {
        void var1_1;
        if (this.a == D.PERCENTAGE) {
            return this.b * context.a / 100.0f;
        }
        return this.a((MeasureContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final float resolveHeight(@NotNull MeasureContext context) {
        void var1_1;
        if (this.a == D.PERCENTAGE) {
            return this.b * context.b / 100.0f;
        }
        return this.a((MeasureContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final float resolveLength(@NotNull MeasureContext context) {
        void var1_1;
        if (this.a == D.PERCENTAGE) {
            return this.b / 100.0f * (float)Math.sqrt((context.a * context.a + context.b * context.b) / 2.0f);
        }
        return this.a((MeasureContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final float resolveFontSize(@NotNull MeasureContext context) {
        void var1_1;
        if (this.a == D.PERCENTAGE) {
            return this.b / 100.0f * context.c;
        }
        return this.a((MeasureContext)var1_1);
    }

    public final String toString() {
        return this.b + this.a.suffix();
    }

    public final boolean isZero() {
        return this.b == 0.0f;
    }

    public final float raw() {
        return this.b;
    }

    @NotNull
    public final D unit() {
        return this.a;
    }

    public final boolean isUnspecified() {
        return Length.isUnspecified(this.raw());
    }

    public final boolean isSpecified() {
        return !this.isUnspecified();
    }

    @NotNull
    public final Length coerceNonNegative() {
        if (this.isSpecified() && this.raw() <= 0.0f) {
            return ZERO;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Length orElseIfUnspecified(float value) {
        if (this.isUnspecified()) {
            void var1_1;
            return D.Raw.valueOf((float)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Length multiply(float scalingFactor) {
        void var1_1;
        if (scalingFactor == 0.0f) {
            return ZERO;
        }
        return new Length(this.unit(), (float)(var1_1 * this.raw()));
    }

    public final boolean equals(Object o2) {
        Length length;
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof Length)) {
            return false;
        }
        length = length;
        return this.a == length.a && Float.compare(length.b, this.b) == 0;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.a, Float.valueOf(this.b)});
    }
}

