/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.osgi.p2;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.impldep.org.apache.ivy.osgi.core.BundleArtifact;
import org.gradle.internal.impldep.org.apache.ivy.osgi.core.BundleInfo;
import org.gradle.internal.impldep.org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.gradle.internal.impldep.org.apache.ivy.osgi.repo.EditableRepoDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.osgi.repo.ModuleDescriptorWrapper;
import org.gradle.internal.impldep.org.apache.ivy.osgi.util.Version;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;

public class P2Descriptor
extends EditableRepoDescriptor {
    private Map<String, Map<Version, BundleInfo>> sourceTargetBundles = new HashMap<String, Map<Version, BundleInfo>>();
    private Map<String, Map<Version, BundleInfo>> sourceBundles = new HashMap<String, Map<Version, BundleInfo>>();

    public P2Descriptor(URI repoUri, ExecutionEnvironmentProfileProvider profileProvider) {
        super(repoUri, profileProvider);
    }

    @Override
    public void addBundle(BundleInfo bundleInfo) {
        if (bundleInfo.isSource()) {
            BundleInfo old;
            if (bundleInfo.getSymbolicNameTarget() == null || bundleInfo.getVersionTarget() == null) {
                if (this.getLogLevel() <= 3) {
                    Message.verbose("The source bundle " + bundleInfo.getSymbolicName() + " did not declare its target. Ignoring it");
                }
                return;
            }
            Map<Version, BundleInfo> byVersion = this.sourceBundles.get(bundleInfo.getSymbolicName());
            if (byVersion == null) {
                byVersion = new HashMap<Version, BundleInfo>();
                this.sourceBundles.put(bundleInfo.getSymbolicName(), byVersion);
            }
            byVersion.put(bundleInfo.getVersion(), bundleInfo);
            Map<Version, BundleInfo> byTargetVersion = this.sourceTargetBundles.get(bundleInfo.getSymbolicNameTarget());
            if (byTargetVersion == null) {
                byTargetVersion = new HashMap<Version, BundleInfo>();
                this.sourceTargetBundles.put(bundleInfo.getSymbolicNameTarget(), byTargetVersion);
            }
            if ((old = byTargetVersion.put(bundleInfo.getVersionTarget(), bundleInfo)) != null && !old.equals(bundleInfo) && this.getLogLevel() <= 3) {
                Message.verbose("Duplicate source for the bundle " + bundleInfo.getSymbolicNameTarget() + "@" + bundleInfo.getVersionTarget() + " : " + bundleInfo + " is replacing " + old);
            }
            return;
        }
        super.addBundle(bundleInfo);
    }

    public void finish() {
        this.sourceBundles = null;
        Set<String> bundleIds = this.getCapabilityValues("bundle");
        if (bundleIds == null) {
            return;
        }
        for (String bundleId : bundleIds) {
            for (ModuleDescriptorWrapper mdw : this.findModules("bundle", bundleId)) {
                BundleInfo source;
                String symbolicName = mdw.getBundleInfo().getSymbolicName();
                Map<Version, BundleInfo> byVersion = this.sourceTargetBundles.get(symbolicName);
                if (byVersion == null || (source = byVersion.get(mdw.getBundleInfo().getVersion())) == null) continue;
                for (BundleArtifact artifact : source.getArtifacts()) {
                    mdw.getBundleInfo().addArtifact(artifact);
                }
            }
        }
        this.sourceTargetBundles = null;
    }

    public void addArtifactUrl(String classifier, String id, Version version, URI uri, String format) {
        if (!classifier.equals("osgi.bundle")) {
            return;
        }
        ModuleDescriptorWrapper module = this.findModule(id, version);
        if (module != null) {
            this.addArtifact(module.getBundleInfo(), new BundleArtifact(false, uri, format));
            return;
        }
        Map<Version, BundleInfo> byVersion = this.sourceBundles.get(id);
        if (byVersion == null) {
            return;
        }
        BundleInfo source = byVersion.get(version);
        if (source == null) {
            return;
        }
        this.addArtifact(source, new BundleArtifact(true, uri, format));
    }

    private void addArtifact(BundleInfo bundle, BundleArtifact artifact) {
        BundleArtifact same = null;
        for (BundleArtifact a : bundle.getArtifacts()) {
            if (a.isSource() != artifact.isSource()) continue;
            same = a;
            break;
        }
        if (same != null) {
            if (artifact.getFormat() == null || same.getFormat() != null) {
                return;
            }
            bundle.removeArtifact(same);
        }
        bundle.addArtifact(artifact);
    }
}

