/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.openpgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.BCPGInputStream;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.ContainedPacket;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.Packet;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.SignaturePacket;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.TrustPacket;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.UserAttributePacket;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.UserIDPacket;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPException;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKey;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPSignature;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PGPKeyRing {
    PGPKeyRing() {
    }

    static BCPGInputStream wrap(InputStream inputStream) {
        if (inputStream instanceof BCPGInputStream) {
            return (BCPGInputStream)inputStream;
        }
        return new BCPGInputStream(inputStream);
    }

    static TrustPacket readOptionalTrustPacket(BCPGInputStream bCPGInputStream) throws IOException {
        return bCPGInputStream.nextPacketTag() == 12 ? (TrustPacket)bCPGInputStream.readPacket() : null;
    }

    static List readSignaturesAndTrust(BCPGInputStream bCPGInputStream) throws IOException {
        try {
            ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
            while (bCPGInputStream.nextPacketTag() == 2) {
                SignaturePacket signaturePacket = (SignaturePacket)bCPGInputStream.readPacket();
                TrustPacket trustPacket = PGPKeyRing.readOptionalTrustPacket(bCPGInputStream);
                arrayList.add(new PGPSignature(signaturePacket, trustPacket));
            }
            return arrayList;
        }
        catch (PGPException pGPException) {
            throw new IOException("can't create signature object: " + pGPException.getMessage() + ", cause: " + pGPException.getUnderlyingException().toString());
        }
    }

    static void readUserIDs(BCPGInputStream bCPGInputStream, List list, List list2, List list3) throws IOException {
        while (bCPGInputStream.nextPacketTag() == 13 || bCPGInputStream.nextPacketTag() == 17) {
            ContainedPacket containedPacket;
            Packet packet = bCPGInputStream.readPacket();
            if (packet instanceof UserIDPacket) {
                containedPacket = (UserIDPacket)packet;
                list.add(containedPacket);
            } else {
                containedPacket = (UserAttributePacket)packet;
                list.add(new PGPUserAttributeSubpacketVector(((UserAttributePacket)containedPacket).getSubpackets()));
            }
            list2.add(PGPKeyRing.readOptionalTrustPacket(bCPGInputStream));
            list3.add(PGPKeyRing.readSignaturesAndTrust(bCPGInputStream));
        }
    }

    public abstract PGPPublicKey getPublicKey();

    public abstract Iterator<PGPPublicKey> getPublicKeys();

    public abstract PGPPublicKey getPublicKey(long var1);

    public abstract PGPPublicKey getPublicKey(byte[] var1);

    public abstract Iterator<PGPPublicKey> getKeysWithSignaturesBy(long var1);

    public abstract void encode(OutputStream var1) throws IOException;

    public abstract byte[] getEncoded() throws IOException;
}

