/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.lib;

import org.gradle.internal.impldep.org.eclipse.jgit.lib.Config;

public class GpgConfig {
    private final Config config;

    public GpgConfig(Config config) {
        this.config = config;
    }

    public GpgFormat getKeyFormat() {
        return (GpgFormat)this.config.getEnum(GpgFormat.values(), "gpg", null, "format", GpgFormat.OPENPGP);
    }

    public String getSigningKey() {
        return this.config.getString("user", null, "signingKey");
    }

    public boolean isSignCommits() {
        return this.config.getBoolean("commit", "gpgSign", false);
    }

    public static enum GpgFormat implements Config.ConfigEnum
    {
        OPENPGP("openpgp"),
        X509("x509");

        private final String configValue;

        private GpgFormat(String configValue) {
            this.configValue = configValue;
        }

        @Override
        public boolean matchConfigValue(String s) {
            return this.configValue.equals(s);
        }

        @Override
        public String toConfigValue() {
            return this.configValue;
        }
    }
}

