/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.distinctcount;

import com.dynatrace.hash4j.distinctcount.StateChangeObserver;

interface DistinctCounter<T extends DistinctCounter<T, R>, R extends Estimator<T>> {
    public T add(long var1);

    public T addToken(int var1);

    public T add(T var1);

    public double getDistinctCountEstimate();

    public double getDistinctCountEstimate(R var1);

    public T copy();

    public T downsize(int var1);

    public T reset();

    public byte[] getState();

    public int getP();

    public T add(long var1, StateChangeObserver var3);

    public T addToken(int var1, StateChangeObserver var2);

    public double getStateChangeProbability();

    public static int computeToken(long hashValue) {
        int idx = (int)(hashValue >>> 38);
        int nlz = Long.numberOfLeadingZeros((hashValue ^ 0xFFFFFFFFFFFFFFFFL) << 26 ^ 0xFFFFFFFFFFFFFFFFL);
        return idx << 6 | nlz;
    }

    public static long reconstructHash(int token) {
        long idx = (long)token & 0xFFFFFFC0L;
        int nlz = token & 0x3F;
        return 0x3FFFFFFFFFL >>> nlz | idx << 32;
    }

    @FunctionalInterface
    public static interface Estimator<T> {
        public double estimate(T var1);
    }
}

