/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.signing;

import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.Digest;
import org.jetbrains.zip.signer.metadata.SignatureAlgorithm;
import org.jetbrains.zip.signer.metadata.SignatureData;
import org.jetbrains.zip.signer.metadata.SignerBlock;
import org.jetbrains.zip.signer.signing.SignatureProvider;
import org.jetbrains.zip.signer.verifier.DefaultSignatureVerifier;
import org.jetbrains.zip.signer.verifier.SignatureVerifier;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a,\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0000\u00a8\u0006\u000e"}, d2={"generateSignatureOverData", "", "digest", "Lorg/jetbrains/zip/signer/metadata/Digest;", "signatureProvider", "Lorg/jetbrains/zip/signer/signing/SignatureProvider;", "signatureVerifier", "Lorg/jetbrains/zip/signer/verifier/SignatureVerifier;", "generateSignerBlock", "Lorg/jetbrains/zip/signer/metadata/SignerBlock;", "certificates", "", "Ljava/security/cert/X509Certificate;", "contentDigests", "lib"})
public final class SigningKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SignerBlock generateSignerBlock(@NotNull List<? extends X509Certificate> certificates, @NotNull SignatureProvider signatureProvider, @NotNull List<Digest> contentDigests) {
        Object v0;
        SignatureAlgorithm signatureAlgorithm;
        List encodedCertificates;
        Digest $this$mapTo$iv$iv;
        block4: {
            Object object;
            Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
            Intrinsics.checkNotNullParameter((Object)signatureProvider, (String)"signatureProvider");
            Intrinsics.checkNotNullParameter(contentDigests, (String)"contentDigests");
            if (certificates.isEmpty()) {
                throw new SignatureException("No certificates configured for signer");
            }
            Iterable $this$map$iv = certificates;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Object object2 = $this$mapTo$iv$iv.iterator();
            while (object2.hasNext()) {
                void it;
                Object item$iv$iv = object2.next();
                object = (X509Certificate)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                byte[] byArray = it.getEncoded();
                collection.add(byArray);
            }
            encodedCertificates = (List)destination$iv$iv;
            signatureAlgorithm = signatureProvider.getSignatureAlgorithm();
            destination$iv$iv = contentDigests;
            boolean bl = false;
            object2 = destination$iv$iv;
            boolean bl2 = false;
            object = object2.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                Digest it = (Digest)e;
                boolean bl3 = false;
                if (!(it.getAlgorithm() == signatureAlgorithm.getContentDigestAlgorithm())) continue;
                v0 = e;
                break block4;
            }
            v0 = null;
        }
        $this$mapTo$iv$iv = v0;
        if ($this$mapTo$iv$iv == null) {
            throw new RuntimeException((Object)((Object)signatureAlgorithm.getContentDigestAlgorithm()) + " content digest not computed");
        }
        Digest digest = $this$mapTo$iv$iv;
        DefaultSignatureVerifier signatureVerifier = new DefaultSignatureVerifier(certificates, signatureAlgorithm);
        SignatureData signature = new SignatureData(signatureAlgorithm, SigningKt.generateSignatureOverData(digest, signatureProvider, signatureVerifier));
        return new SignerBlock(encodedCertificates, CollectionsKt.listOf((Object)signature));
    }

    private static final byte[] generateSignatureOverData(Digest digest, SignatureProvider signatureProvider, SignatureVerifier signatureVerifier) {
        byte[] signatureBytes = signatureProvider.sign(digest.getDigestBytes());
        signatureVerifier.verify(digest.getDigestBytes(), signatureBytes);
        return signatureBytes;
    }
}

