/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyGraphBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleSelectors;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.RejectedModuleMessageBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.VirtualPlatformState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.VersionConflictResolutionDetails;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.internal.Pair;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentGraphSpecificResolveState;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.DefaultComponentOverrideMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.result.DefaultBuildableComponentResolveResult;

public class ComponentState
implements ComponentResolutionState,
DependencyGraphComponent {
    private final ComponentIdentifier componentIdentifier;
    private final ModuleVersionIdentifier id;
    private final ComponentMetaDataResolver resolver;
    private final List<NodeState> nodes = Lists.newLinkedList();
    private final Long resultId;
    private final ModuleResolveState module;
    private final List<ComponentSelectionDescriptorInternal> selectionCauses = Lists.newArrayList();
    private final DefaultImmutableCapability implicitCapability;
    private final int hashCode;
    private volatile ComponentGraphResolveState resolveState;
    private volatile ComponentGraphSpecificResolveState graphResolveState;
    private ComponentSelectionState state = ComponentSelectionState.Selectable;
    private ModuleVersionResolveException metadataResolveFailure;
    private ModuleSelectors<SelectorState> selectors;
    private DependencyGraphBuilder.VisitState visitState = DependencyGraphBuilder.VisitState.NotSeen;
    private boolean rejected;
    private boolean root;
    private Pair<Capability, Collection<NodeState>> capabilityReject;
    private ComponentSelectionReason cachedReason;

    ComponentState(Long resultId, ModuleResolveState module, ModuleVersionIdentifier id, ComponentIdentifier componentIdentifier, ComponentMetaDataResolver resolver) {
        this.resultId = resultId;
        this.module = module;
        this.id = id;
        this.componentIdentifier = componentIdentifier;
        this.resolver = resolver;
        this.implicitCapability = DefaultImmutableCapability.defaultCapabilityForComponent(id);
        this.hashCode = 31 * id.hashCode() ^ resultId.hashCode();
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public String getVersion() {
        return this.id.getVersion();
    }

    @Override
    public Long getResultId() {
        return this.resultId;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getRepositoryName() {
        return this.graphResolveState.getRepositoryName();
    }

    @Override
    public ModuleVersionIdentifier getModuleVersion() {
        return this.id;
    }

    @Nullable
    public ModuleVersionResolveException getMetadataResolveFailure() {
        return this.metadataResolveFailure;
    }

    public DependencyGraphBuilder.VisitState getVisitState() {
        return this.visitState;
    }

    public void setVisitState(DependencyGraphBuilder.VisitState visitState) {
        this.visitState = visitState;
    }

    public List<NodeState> getNodes() {
        return this.nodes;
    }

    ModuleResolveState getModule() {
        return this.module;
    }

    public void selectAndRestartModule() {
        this.module.replaceWith(this);
    }

    @Override
    @Nullable
    public ComponentGraphResolveMetadata getMetadataOrNull() {
        this.resolve();
        if (this.resolveState == null) {
            return null;
        }
        return this.resolveState.getMetadata();
    }

    public ComponentGraphResolveMetadata getMetadata() {
        this.resolve();
        return this.resolveState.getMetadata();
    }

    @Override
    public ComponentGraphResolveState getResolveState() {
        this.resolve();
        assert (this.resolveState != null);
        return this.resolveState;
    }

    @Nullable
    public ComponentGraphResolveState getResolveStateOrNull() {
        this.resolve();
        return this.resolveState;
    }

    @Override
    public ComponentIdentifier getComponentId() {
        if (this.resolveState != null) {
            return this.resolveState.getId();
        }
        return this.componentIdentifier;
    }

    public void restartIncomingEdges(ComponentState selected) {
        for (NodeState configuration : this.nodes) {
            configuration.restart(selected);
        }
    }

    public void setSelectors(ModuleSelectors<SelectorState> selectors) {
        this.selectors = selectors;
    }

    public boolean alreadyResolved() {
        return this.resolveState != null || this.metadataResolveFailure != null;
    }

    public void resolve() {
        ComponentOverrideMetadata componentOverrideMetadata;
        if (this.alreadyResolved()) {
            return;
        }
        if (this.selectors != null && this.selectors.size() > 0) {
            ComponentOverrideMetadata md;
            SelectorState firstSelector = this.selectors.first();
            componentOverrideMetadata = md = DefaultComponentOverrideMetadata.forDependency(firstSelector.isChanging(), this.selectors.getFirstDependencyArtifact(), firstSelector.getClientModule());
        } else {
            componentOverrideMetadata = DefaultComponentOverrideMetadata.EMPTY;
        }
        if (this.tryResolveVirtualPlatform()) {
            return;
        }
        DefaultBuildableComponentResolveResult result2 = new DefaultBuildableComponentResolveResult();
        this.resolver.resolve(this.componentIdentifier, componentOverrideMetadata, result2);
        if (result2.getFailure() != null) {
            this.metadataResolveFailure = result2.getFailure();
            return;
        }
        this.resolveState = result2.getState();
        this.graphResolveState = result2.getGraphState();
    }

    private boolean tryResolveVirtualPlatform() {
        if (this.module.isVirtualPlatform()) {
            for (ComponentState version : this.module.getAllVersions()) {
                ComponentGraphResolveState lenient;
                ComponentGraphResolveState versionState;
                if (version == this || (versionState = version.getResolveStateOrNull()) == null || (lenient = versionState.maybeAsLenientPlatform((ModuleComponentIdentifier)this.componentIdentifier, this.id)) == null) continue;
                this.setState(lenient, ComponentGraphSpecificResolveState.EMPTY_STATE);
                return true;
            }
        }
        return false;
    }

    public void setState(ComponentGraphResolveState state, ComponentGraphSpecificResolveState graphState) {
        this.resolveState = state;
        this.graphResolveState = graphState;
        this.metadataResolveFailure = null;
    }

    public void addConfiguration(NodeState node) {
        this.nodes.add(node);
    }

    @Override
    public ComponentSelectionReason getSelectionReason() {
        if (this.root) {
            return ComponentSelectionReasons.root();
        }
        if (this.cachedReason != null) {
            return this.cachedReason;
        }
        ComponentSelectionReasonInternal reason = ComponentSelectionReasons.empty();
        for (SelectorState selectorState : this.module.getSelectors()) {
            if (selectorState.getFailure() != null) continue;
            selectorState.addReasonsForSelector(reason);
        }
        for (ComponentSelectionDescriptorInternal selectionCause : VersionConflictResolutionDetails.mergeCauses(this.selectionCauses)) {
            reason.addCause(selectionCause);
        }
        this.cachedReason = reason;
        return reason;
    }

    boolean hasStrongOpinion() {
        return StreamSupport.stream(this.module.getSelectors().spliterator(), false).filter(s -> s.getFailure() == null).anyMatch(SelectorState::hasStrongOpinion);
    }

    @Override
    public void addCause(ComponentSelectionDescriptorInternal componentSelectionDescriptor) {
        this.selectionCauses.add(componentSelectionDescriptor);
    }

    public void setRoot() {
        this.root = true;
    }

    @Override
    public List<ResolvedGraphVariant> getSelectedVariants() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.addSelectedVariants(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    private void addSelectedVariants(Consumer<ResolvedGraphVariant> consumer) {
        for (NodeState node : this.nodes) {
            if (!node.isSelected()) continue;
            consumer.accept(node);
        }
    }

    public List<ComponentState> getDependents() {
        ArrayList incoming = Lists.newArrayListWithCapacity((int)this.nodes.size());
        for (NodeState configuration : this.nodes) {
            for (EdgeState dependencyEdge : configuration.getIncomingEdges()) {
                incoming.add(dependencyEdge.getFrom().getComponent());
            }
        }
        return incoming;
    }

    @Override
    public Collection<? extends ModuleVersionIdentifier> getAllVersions() {
        Collection<ComponentState> moduleVersions = this.module.getAllVersions();
        ArrayList out = Lists.newArrayListWithCapacity((int)moduleVersions.size());
        for (ComponentState moduleVersion : moduleVersions) {
            out.add(moduleVersion.id);
        }
        return out;
    }

    public boolean isSelected() {
        return this.state == ComponentSelectionState.Selected;
    }

    public boolean isCandidateForConflictResolution() {
        return this.state.isCandidateForConflictResolution();
    }

    void evict() {
        this.state = ComponentSelectionState.Evicted;
    }

    void select() {
        this.state = ComponentSelectionState.Selected;
    }

    void makeSelectable() {
        this.state = ComponentSelectionState.Selectable;
    }

    @Override
    public void reject() {
        this.rejected = true;
    }

    public void rejectForCapabilityConflict(Capability capability, Collection<NodeState> conflictedNodes) {
        this.rejected = true;
        if (this.capabilityReject == null) {
            this.capabilityReject = Pair.of(capability, conflictedNodes);
        } else {
            this.mergeCapabilityRejects(capability, conflictedNodes);
        }
    }

    private void mergeCapabilityRejects(Capability capability, Collection<NodeState> conflictedNodes) {
        if (this.capabilityReject.getLeft().equals(capability)) {
            this.capabilityReject.getRight().addAll(conflictedNodes);
        } else {
            this.capabilityReject = Pair.of(capability, conflictedNodes);
        }
    }

    @Override
    public boolean isRejected() {
        return this.rejected;
    }

    public String getRejectedErrorMessage() {
        if (this.capabilityReject != null) {
            return this.formatCapabilityRejectMessage(this.module.getId(), this.capabilityReject);
        }
        return new RejectedModuleMessageBuilder().buildFailureMessage(this.module);
    }

    private String formatCapabilityRejectMessage(ModuleIdentifier id, Pair<Capability, Collection<NodeState>> capabilityConflict) {
        StringBuilder sb = new StringBuilder("Module '");
        sb.append(id).append("' has been rejected:\n");
        sb.append("   Cannot select module with conflict on ");
        Capability capability = (Capability)capabilityConflict.left;
        sb.append("capability '").append(capability.getGroup()).append(":").append(capability.getName()).append(":").append(capability.getVersion()).append("' also provided by ");
        sb.append(capabilityConflict.getRight());
        return sb.toString();
    }

    @Override
    public Set<VirtualPlatformState> getPlatformOwners() {
        return this.module.getPlatformOwners();
    }

    @Override
    public VirtualPlatformState getPlatformState() {
        return this.module.getPlatformState();
    }

    public void removeOutgoingEdges() {
        for (NodeState configuration : this.getNodes()) {
            configuration.deselect();
        }
    }

    Capability getImplicitCapability() {
        return this.implicitCapability;
    }

    @Nullable
    Capability findCapability(String group, String name) {
        if (this.id.getGroup().equals(group) && this.id.getName().equals(name)) {
            return this.implicitCapability;
        }
        return null;
    }

    boolean hasMoreThanOneSelectedNodeUsingVariantAwareResolution() {
        int count = 0;
        for (NodeState node : this.nodes) {
            if (!node.isSelectedByVariantAwareResolution() || ++count != 2) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentState that = (ComponentState)o;
        return that.resultId.equals(this.resultId);
    }

    public int hashCode() {
        return this.hashCode;
    }

    static enum ComponentSelectionState {
        Selectable(true),
        Selected(true),
        Evicted(false);

        private final boolean candidateForConflictResolution;

        private ComponentSelectionState(boolean candidateForConflictResolution) {
            this.candidateForConflictResolution = candidateForConflictResolution;
        }

        boolean isCandidateForConflictResolution() {
            return this.candidateForConflictResolution;
        }
    }
}

