/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;

public class TransformBackedProvider<OUT, IN>
extends AbstractMinimalProvider<OUT> {
    protected final Class<OUT> type;
    protected final ProviderInternal<? extends IN> provider;
    protected final Transformer<? extends OUT, ? super IN> transformer;

    public TransformBackedProvider(@Nullable Class<OUT> type, ProviderInternal<? extends IN> provider, Transformer<? extends OUT, ? super IN> transformer) {
        this.type = type;
        this.transformer = transformer;
        this.provider = provider;
    }

    @Override
    @Nullable
    public Class<OUT> getType() {
        return this.type;
    }

    @VisibleForTesting
    public Transformer<? extends OUT, ? super IN> getTransformer() {
        return this.transformer;
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        return this.provider.getProducer();
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends OUT> calculateExecutionTimeValue() {
        ValueSupplier.ExecutionTimeValue<IN> value = this.provider.calculateExecutionTimeValue();
        if (value.hasChangingContent()) {
            return ValueSupplier.ExecutionTimeValue.changingValue(new TransformBackedProvider<OUT, IN>(this.type, value.toProvider(), this.transformer));
        }
        return ValueSupplier.ExecutionTimeValue.value(this.mapValue(value.toValue()));
    }

    @Override
    protected ValueSupplier.Value<? extends OUT> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        this.beforeRead();
        ValueSupplier.Value<? extends IN> value = this.provider.calculateValue(consumer);
        return this.mapValue(value);
    }

    @Nonnull
    protected ValueSupplier.Value<OUT> mapValue(ValueSupplier.Value<? extends IN> value) {
        if (value.isMissing()) {
            return value.asType();
        }
        return value.transform(this.transformer);
    }

    protected void beforeRead() {
        this.provider.getProducer().visitContentProducerTasks(producer -> {
            if (!producer.getState().getExecuted()) {
                throw new InvalidUserCodeException(String.format("Querying the mapped value of %s before %s has completed is not supported", this.provider, producer));
            }
        });
    }

    @Override
    public String toString() {
        return "map(" + (this.type == null ? "" : this.type.getName() + " ") + this.provider + ")";
    }
}

