/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.result;

import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.junit.result.TestOutputStore;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

public abstract class TestOutputStoreBackedResultsProvider
implements TestResultsProvider {
    private final TestOutputStore outputStore;
    private final ConcurrentMap<Thread, TestOutputStore.Reader> readers;

    public TestOutputStoreBackedResultsProvider(TestOutputStore outputStore) {
        this.outputStore = outputStore;
        this.readers = Maps.newConcurrentMap();
    }

    protected void withReader(Action<TestOutputStore.Reader> action) {
        action.execute(this.getReader());
    }

    private TestOutputStore.Reader getReader() {
        Thread thread = Thread.currentThread();
        TestOutputStore.Reader reader2 = (TestOutputStore.Reader)this.readers.get(thread);
        if (reader2 == null) {
            reader2 = this.outputStore.reader();
            this.readers.put(thread, reader2);
        }
        return reader2;
    }

    @Override
    public void close() throws IOException {
        CompositeStoppable.stoppable(this.readers.values()).stop();
    }
}

