/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.JavaVersion;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.file.Directory;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.internal.tasks.compile.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.JavaCompileExecutableUtils;
import org.gradle.api.internal.tasks.testing.TestExecutableUtils;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.BasePluginExtension;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.JvmEcosystemPlugin;
import org.gradle.api.plugins.JvmToolchainsPlugin;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.plugins.internal.DefaultJavaPluginConvention;
import org.gradle.api.plugins.internal.DefaultJavaPluginExtension;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.internal.NaggingJavaPluginConvention;
import org.gradle.api.plugins.jvm.internal.JvmLanguageUtilities;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.javadoc.internal.JavadocExecutableUtils;
import org.gradle.api.tasks.testing.JUnitXmlReport;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.Cast;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.jvm.JavaModuleDetector;
import org.gradle.jvm.tasks.Jar;
import org.gradle.jvm.toolchain.JavaCompiler;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.DefaultToolchainSpec;
import org.gradle.language.jvm.tasks.ProcessResources;

public abstract class JavaBasePlugin
implements Plugin<Project> {
    public static final String CHECK_TASK_NAME = "check";
    public static final String VERIFICATION_GROUP = "verification";
    public static final String BUILD_TASK_NAME = "build";
    public static final String BUILD_DEPENDENTS_TASK_NAME = "buildDependents";
    public static final String BUILD_NEEDED_TASK_NAME = "buildNeeded";
    public static final String DOCUMENTATION_GROUP = "documentation";
    public static final String COMPILE_CLASSPATH_PACKAGING_SYSTEM_PROPERTY = "org.gradle.java.compile-classpath-packaging";
    public static final Set<String> UNPUBLISHABLE_VARIANT_ARTIFACTS = JavaConfigurationVariantMapping.UNPUBLISHABLE_VARIANT_ARTIFACTS;
    private final boolean javaClasspathPackaging;
    private final ObjectFactory objectFactory;
    private final JvmPluginServices jvmPluginServices;

    @Inject
    public JavaBasePlugin(ObjectFactory objectFactory, JvmPluginServices jvmPluginServices) {
        this.objectFactory = objectFactory;
        this.javaClasspathPackaging = Boolean.getBoolean(COMPILE_CLASSPATH_PACKAGING_SYSTEM_PROPERTY);
        this.jvmPluginServices = jvmPluginServices;
    }

    @Inject
    protected abstract JvmLanguageUtilities getJvmLanguageUtils();

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(BasePlugin.class);
        project.getPluginManager().apply(JvmEcosystemPlugin.class);
        project.getPluginManager().apply(ReportingBasePlugin.class);
        project.getPluginManager().apply(JvmToolchainsPlugin.class);
        DefaultJavaPluginExtension javaPluginExtension = this.addExtensions(project);
        this.configureCompileDefaults(project, javaPluginExtension);
        this.configureSourceSetDefaults(project, javaPluginExtension);
        this.configureJavaDoc(project, javaPluginExtension);
        this.configureTest(project, javaPluginExtension);
        this.configureBuildNeeded(project);
        this.configureBuildDependents(project);
        this.configureArchiveDefaults(project);
    }

    private DefaultJavaPluginExtension addExtensions(Project project) {
        DefaultToolchainSpec toolchainSpec = this.objectFactory.newInstance(DefaultToolchainSpec.class, new Object[0]);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByName("sourceSets");
        DefaultJavaPluginExtension javaPluginExtension = project.getExtensions().create(JavaPluginExtension.class, "java", DefaultJavaPluginExtension.class, project, sourceSets, toolchainSpec);
        DeprecationLogger.whileDisabled(() -> project.getConvention().getPlugins().put("java", new NaggingJavaPluginConvention(this.objectFactory.newInstance(DefaultJavaPluginConvention.class, project, javaPluginExtension))));
        return javaPluginExtension;
    }

    private void configureSourceSetDefaults(Project project, JavaPluginExtension javaPluginExtension) {
        javaPluginExtension.getSourceSets().all(sourceSet -> {
            ConfigurationContainer configurations = project.getConfigurations();
            this.defineConfigurationsForSourceSet((SourceSet)sourceSet, (RoleBasedConfigurationContainerInternal)configurations);
            this.definePathsForSourceSet((SourceSet)sourceSet, project);
            this.createProcessResourcesTask((SourceSet)sourceSet, sourceSet.getResources(), project);
            TaskProvider<JavaCompile> compileTask = this.createCompileJavaTask((SourceSet)sourceSet, sourceSet.getJava(), project);
            this.createClassesTask((SourceSet)sourceSet, project);
            this.configureLibraryElements(compileTask, (SourceSet)sourceSet, configurations, this.objectFactory);
            this.configureTargetPlatform(compileTask, (SourceSet)sourceSet, configurations);
        });
    }

    private void configureLibraryElements(TaskProvider<JavaCompile> compileJava, SourceSet sourceSet, ConfigurationContainer configurations, ObjectFactory objectFactory) {
        Provider<LibraryElements> libraryElements = compileJava.flatMap(x -> x.getModularity().getInferModulePath()).map(inferModulePath -> {
            if (this.javaClasspathPackaging) {
                return "jar";
            }
            List<File> sourcesRoots = CompilationSourceDirs.inferSourceRoots((FileTreeInternal)sourceSet.getJava().getAsFileTree());
            if (JavaModuleDetector.isModuleSource(inferModulePath, sourcesRoots)) {
                return "jar";
            }
            return "classes";
        }).map(value -> objectFactory.named(LibraryElements.class, (String)value));
        Configuration compileClasspath = configurations.getByName(sourceSet.getCompileClasspathConfigurationName());
        compileClasspath.getAttributes().attributeProvider(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, libraryElements);
    }

    private void configureTargetPlatform(TaskProvider<JavaCompile> compileTask, SourceSet sourceSet, ConfigurationContainer configurations) {
        this.getJvmLanguageUtils().useDefaultTargetPlatformInference(configurations.getByName(sourceSet.getCompileClasspathConfigurationName()), compileTask);
        this.getJvmLanguageUtils().useDefaultTargetPlatformInference(configurations.getByName(sourceSet.getRuntimeClasspathConfigurationName()), compileTask);
    }

    private TaskProvider<JavaCompile> createCompileJavaTask(SourceSet sourceSet, SourceDirectorySet javaSource, Project project) {
        NamedDomainObjectProvider compileTask = project.getTasks().register(sourceSet.getCompileJavaTaskName(), JavaCompile.class, javaCompile -> {
            ConventionMapping conventionMapping = javaCompile.getConventionMapping();
            conventionMapping.map("classpath", sourceSet::getCompileClasspath);
            JvmPluginsHelper.configureAnnotationProcessorPath(sourceSet, javaSource, javaCompile.getOptions(), project);
            javaCompile.setDescription("Compiles " + javaSource + ".");
            javaCompile.setSource(javaSource);
            Provider<JavaToolchainSpec> toolchainOverrideSpec = project.provider(() -> JavaCompileExecutableUtils.getExecutableOverrideToolchainSpec(javaCompile, this.objectFactory));
            javaCompile.getJavaCompiler().convention(this.getToolchainTool(project, JavaToolchainService::compilerFor, toolchainOverrideSpec));
            String generatedHeadersDir = "generated/sources/headers/" + javaSource.getName() + "/" + sourceSet.getName();
            javaCompile.getOptions().getHeaderOutputDirectory().convention(project.getLayout().getBuildDirectory().dir(generatedHeadersDir));
            JavaPluginExtension javaPluginExtension = project.getExtensions().getByType(JavaPluginExtension.class);
            javaCompile.getModularity().getInferModulePath().convention(javaPluginExtension.getModularity().getInferModulePath());
        });
        JvmPluginsHelper.configureOutputDirectoryForSourceSet(sourceSet, javaSource, project, (TaskProvider<? extends AbstractCompile>)compileTask, compileTask.map(JavaCompile::getOptions));
        return compileTask;
    }

    private void createProcessResourcesTask(SourceSet sourceSet, SourceDirectorySet resourceSet, Project target) {
        NamedDomainObjectProvider processResources = target.getTasks().register(sourceSet.getProcessResourcesTaskName(), ProcessResources.class, resourcesTask -> {
            resourcesTask.setDescription("Processes " + resourceSet + ".");
            new DslObject(resourcesTask.getRootSpec()).getConventionMapping().map("destinationDir", () -> sourceSet.getOutput().getResourcesDir());
            resourcesTask.from(resourceSet);
        });
        DefaultSourceSetOutput output = (DefaultSourceSetOutput)Cast.uncheckedCast(sourceSet.getOutput());
        output.setResourcesContributor(processResources.map(Copy::getDestinationDir), (TaskProvider<?>)processResources);
    }

    private void createClassesTask(SourceSet sourceSet, Project target) {
        sourceSet.compiledBy(target.getTasks().register(sourceSet.getClassesTaskName(), classesTask -> {
            classesTask.setGroup(BUILD_TASK_NAME);
            classesTask.setDescription("Assembles " + sourceSet.getOutput() + ".");
            classesTask.dependsOn(sourceSet.getOutput().getDirs());
            classesTask.dependsOn(sourceSet.getCompileJavaTaskName());
            classesTask.dependsOn(sourceSet.getProcessResourcesTaskName());
        }));
    }

    private void definePathsForSourceSet(SourceSet sourceSet, Project project) {
        ConventionMapping outputConventionMapping = ((IConventionAware)((Object)sourceSet.getOutput())).getConventionMapping();
        outputConventionMapping.map("resourcesDir", () -> {
            String classesDirName = "resources/" + sourceSet.getName();
            return project.getLayout().getBuildDirectory().dir(classesDirName).get().getAsFile();
        });
        sourceSet.getJava().srcDir("src/" + sourceSet.getName() + "/java");
        sourceSet.getResources().srcDir("src/" + sourceSet.getName() + "/resources");
    }

    private void defineConfigurationsForSourceSet(SourceSet sourceSet, RoleBasedConfigurationContainerInternal configurations) {
        String implementationConfigurationName = sourceSet.getImplementationConfigurationName();
        String runtimeOnlyConfigurationName = sourceSet.getRuntimeOnlyConfigurationName();
        String compileOnlyConfigurationName = sourceSet.getCompileOnlyConfigurationName();
        String compileClasspathConfigurationName = sourceSet.getCompileClasspathConfigurationName();
        String annotationProcessorConfigurationName = sourceSet.getAnnotationProcessorConfigurationName();
        String runtimeClasspathConfigurationName = sourceSet.getRuntimeClasspathConfigurationName();
        String sourceSetName = sourceSet.toString();
        Configuration implementationConfiguration = configurations.maybeCreateDependencyScopeUnlocked(implementationConfigurationName);
        implementationConfiguration.setVisible(false);
        implementationConfiguration.setDescription("Implementation only dependencies for " + sourceSetName + ".");
        Configuration compileOnlyConfiguration = configurations.maybeCreateDependencyScopeUnlocked(compileOnlyConfigurationName);
        compileOnlyConfiguration.setVisible(false);
        compileOnlyConfiguration.setDescription("Compile only dependencies for " + sourceSetName + ".");
        Configuration compileClasspathConfiguration = configurations.maybeCreateResolvableUnlocked(compileClasspathConfigurationName);
        compileClasspathConfiguration.setVisible(false);
        compileClasspathConfiguration.extendsFrom(compileOnlyConfiguration, implementationConfiguration);
        compileClasspathConfiguration.setDescription("Compile classpath for " + sourceSetName + ".");
        this.jvmPluginServices.configureAsCompileClasspath(compileClasspathConfiguration);
        Configuration annotationProcessorConfiguration = configurations.maybeCreateResolvableDependencyScopeUnlocked(annotationProcessorConfigurationName);
        annotationProcessorConfiguration.setVisible(false);
        annotationProcessorConfiguration.setDescription("Annotation processors and their dependencies for " + sourceSetName + ".");
        this.jvmPluginServices.configureAsRuntimeClasspath(annotationProcessorConfiguration);
        Configuration runtimeOnlyConfiguration = configurations.maybeCreateDependencyScopeUnlocked(runtimeOnlyConfigurationName);
        runtimeOnlyConfiguration.setVisible(false);
        runtimeOnlyConfiguration.setDescription("Runtime only dependencies for " + sourceSetName + ".");
        Configuration runtimeClasspathConfiguration = configurations.maybeCreateResolvableUnlocked(runtimeClasspathConfigurationName);
        runtimeClasspathConfiguration.setVisible(false);
        runtimeClasspathConfiguration.setDescription("Runtime classpath of " + sourceSetName + ".");
        runtimeClasspathConfiguration.extendsFrom(runtimeOnlyConfiguration, implementationConfiguration);
        this.jvmPluginServices.configureAsRuntimeClasspath(runtimeClasspathConfiguration);
        sourceSet.setCompileClasspath(compileClasspathConfiguration);
        sourceSet.setRuntimeClasspath(sourceSet.getOutput().plus(runtimeClasspathConfiguration));
        sourceSet.setAnnotationProcessorPath(annotationProcessorConfiguration);
    }

    private void configureCompileDefaults(Project project, DefaultJavaPluginExtension javaExtension) {
        project.getTasks().withType(AbstractCompile.class).configureEach(compile -> {
            ConventionMapping conventionMapping = compile.getConventionMapping();
            conventionMapping.map("sourceCompatibility", () -> JavaBasePlugin.computeSourceCompatibilityConvention(javaExtension, compile).toString());
            conventionMapping.map("targetCompatibility", () -> JavaBasePlugin.computeTargetCompatibilityConvention(javaExtension, compile).toString());
            compile.getDestinationDirectory().convention(project.getProviders().provider(new BackwardCompatibilityOutputDirectoryConvention((AbstractCompile)compile)));
        });
    }

    private static JavaVersion computeSourceCompatibilityConvention(DefaultJavaPluginExtension javaExtension, AbstractCompile compileTask) {
        return JavaBasePlugin.computeCompatibilityConvention(compileTask, javaExtension.getRawSourceCompatibility(), javaExtension::getSourceCompatibility);
    }

    private static JavaVersion computeTargetCompatibilityConvention(DefaultJavaPluginExtension javaExtension, AbstractCompile compileTask) {
        JavaVersion rawTargetCompatibility = javaExtension.getRawTargetCompatibility();
        if (rawTargetCompatibility == null) {
            rawTargetCompatibility = JavaVersion.toVersion(compileTask.getSourceCompatibility());
        }
        return JavaBasePlugin.computeCompatibilityConvention(compileTask, rawTargetCompatibility, javaExtension::getTargetCompatibility);
    }

    private static JavaVersion computeCompatibilityConvention(AbstractCompile compile, @Nullable JavaVersion rawConvention, Supplier<JavaVersion> javaVersionSupplier) {
        if (compile instanceof JavaCompile) {
            JavaCompile javaCompile = (JavaCompile)compile;
            if (javaCompile.getOptions().getRelease().isPresent()) {
                return JavaVersion.toVersion(javaCompile.getOptions().getRelease().get());
            }
            if (rawConvention != null) {
                return rawConvention;
            }
            return JavaVersion.toVersion(((JavaCompiler)javaCompile.getJavaCompiler().get()).getMetadata().getLanguageVersion().toString());
        }
        if (compile instanceof GroovyCompile) {
            GroovyCompile groovyCompile = (GroovyCompile)compile;
            if (rawConvention != null) {
                return rawConvention;
            }
            return JavaVersion.toVersion(((JavaLauncher)groovyCompile.getJavaLauncher().get()).getMetadata().getLanguageVersion().toString());
        }
        return javaVersionSupplier.get();
    }

    private void configureJavaDoc(Project project, JavaPluginExtension javaPluginExtension) {
        project.getTasks().withType(Javadoc.class).configureEach(javadoc -> {
            javadoc.getConventionMapping().map("destinationDir", () -> new File(((Directory)javaPluginExtension.getDocsDir().get()).getAsFile(), "javadoc"));
            javadoc.getConventionMapping().map("title", () -> project.getExtensions().getByType(ReportingExtension.class).getApiDocTitle());
            Provider<JavaToolchainSpec> toolchainOverrideSpec = project.provider(() -> JavadocExecutableUtils.getExecutableOverrideToolchainSpec(javadoc, this.objectFactory));
            javadoc.getJavadocTool().convention(this.getToolchainTool(project, JavaToolchainService::javadocToolFor, toolchainOverrideSpec));
        });
    }

    private void configureBuildNeeded(Project project) {
        project.getTasks().register(BUILD_NEEDED_TASK_NAME, buildTask -> {
            buildTask.setDescription("Assembles and tests this project and all projects it depends on.");
            buildTask.setGroup(BUILD_TASK_NAME);
            buildTask.dependsOn(BUILD_TASK_NAME);
        });
    }

    private void configureBuildDependents(Project project) {
        project.getTasks().register(BUILD_DEPENDENTS_TASK_NAME, buildTask -> {
            buildTask.setDescription("Assembles and tests this project and all projects that depend on it.");
            buildTask.setGroup(BUILD_TASK_NAME);
            buildTask.dependsOn(BUILD_TASK_NAME);
        });
    }

    private void configureArchiveDefaults(Project project) {
        BasePluginExtension basePluginExtension = project.getExtensions().getByType(BasePluginExtension.class);
        project.getTasks().withType(Jar.class).configureEach(task -> task.getDestinationDirectory().convention((Provider)basePluginExtension.getLibsDirectory()));
    }

    private void configureTest(Project project, JavaPluginExtension javaPluginExtension) {
        project.getTasks().withType(Test.class).configureEach(test -> this.configureTestDefaults((Test)test, project, javaPluginExtension));
    }

    private void configureTestDefaults(Test test, Project project, JavaPluginExtension javaPluginExtension) {
        DirectoryReport htmlReport = test.getReports().getHtml();
        JUnitXmlReport xmlReport = test.getReports().getJunitXml();
        xmlReport.getOutputLocation().convention(javaPluginExtension.getTestResultsDir().dir(test.getName()));
        htmlReport.getOutputLocation().convention(javaPluginExtension.getTestReportDir().dir(test.getName()));
        test.getBinaryResultsDirectory().convention(javaPluginExtension.getTestResultsDir().dir(test.getName() + "/binary"));
        test.workingDir(project.getProjectDir());
        Provider<JavaToolchainSpec> toolchainOverrideSpec = project.provider(() -> TestExecutableUtils.getExecutableToolchainSpec(test, this.objectFactory));
        test.getJavaLauncher().convention(this.getToolchainTool(project, JavaToolchainService::launcherFor, toolchainOverrideSpec));
    }

    private <T> Provider<T> getToolchainTool(Project project, BiFunction<JavaToolchainService, JavaToolchainSpec, Provider<T>> toolMapper, Provider<JavaToolchainSpec> toolchainOverride) {
        JavaToolchainService service = project.getExtensions().getByType(JavaToolchainService.class);
        JavaPluginExtension extension = project.getExtensions().getByType(JavaPluginExtension.class);
        return toolchainOverride.orElse(extension.getToolchain()).flatMap(spec -> (Provider)toolMapper.apply(service, (JavaToolchainSpec)spec));
    }

    private static class BackwardCompatibilityOutputDirectoryConvention
    implements Callable<Directory> {
        private final AbstractCompile compile;
        private boolean recursiveCall;

        public BackwardCompatibilityOutputDirectoryConvention(AbstractCompile compile) {
            this.compile = compile;
        }

        @Override
        @Nullable
        public Directory call() throws Exception {
            File legacyValue;
            Method getter = GeneratedSubclasses.unpackType(this.compile).getMethod("getDestinationDir", new Class[0]);
            if (getter.getDeclaringClass() == AbstractCompile.class) {
                return null;
            }
            if (this.recursiveCall) {
                return null;
            }
            this.recursiveCall = true;
            try {
                legacyValue = this.compile.getDestinationDir();
            }
            finally {
                this.recursiveCall = false;
            }
            if (legacyValue == null) {
                return null;
            }
            return this.compile.getProject().getLayout().getProjectDirectory().dir(legacyValue.getAbsolutePath());
        }
    }
}

