/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.impldep.com.google.common.util.concurrent.Callables;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.CurrentJvmToolchainSpec;

public abstract class CheckstylePlugin
extends AbstractCodeQualityPlugin<Checkstyle> {
    public static final String DEFAULT_CHECKSTYLE_VERSION = "9.3";
    private static final String CONFIG_DIR_NAME = "config/checkstyle";
    private CheckstyleExtension extension;

    @Override
    protected String getToolName() {
        return "Checkstyle";
    }

    @Override
    protected Class<Checkstyle> getTaskType() {
        return Checkstyle.class;
    }

    @Inject
    protected JavaToolchainService getToolchainService() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected CodeQualityExtension createExtension() {
        this.extension = this.project.getExtensions().create("checkstyle", CheckstyleExtension.class, this.project);
        this.extension.setToolVersion(DEFAULT_CHECKSTYLE_VERSION);
        Directory directory = this.project.getRootProject().getLayout().getProjectDirectory().dir(CONFIG_DIR_NAME);
        this.extension.getConfigDirectory().convention(directory);
        this.extension.setConfig(this.project.getResources().getText().fromFile(this.extension.getConfigDirectory().file("checkstyle.xml").orElse(directory.file("checkstyle.xml"))));
        return this.extension;
    }

    @Override
    protected void configureConfiguration(Configuration configuration) {
        this.configureDefaultDependencies(configuration);
    }

    @Override
    protected void configureTaskDefaults(Checkstyle task, String baseName) {
        Configuration configuration = this.project.getConfigurations().getAt(this.getConfigurationName());
        this.configureTaskConventionMapping(configuration, task);
        this.configureReportsConventionMapping(task, baseName);
        this.configureToolchains(task);
    }

    private void configureDefaultDependencies(Configuration configuration) {
        configuration.defaultDependencies(dependencies -> dependencies.add(this.project.getDependencies().create("com.puppycrawl.tools:checkstyle:" + this.extension.getToolVersion())));
    }

    private void configureTaskConventionMapping(Configuration configuration, Checkstyle task) {
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("checkstyleClasspath", Callables.returning((Object)configuration));
        taskMapping.map("config", () -> this.extension.getConfig());
        taskMapping.map("configProperties", () -> this.extension.getConfigProperties());
        taskMapping.map("showViolations", () -> this.extension.isShowViolations());
        taskMapping.map("maxErrors", () -> this.extension.getMaxErrors());
        taskMapping.map("maxWarnings", () -> this.extension.getMaxWarnings());
        task.getConfigDirectory().convention((Provider)this.extension.getConfigDirectory());
        task.getEnableExternalDtdLoad().convention(this.extension.getEnableExternalDtdLoad());
        task.getIgnoreFailuresProperty().convention(this.project.provider(() -> this.extension.isIgnoreFailures()));
    }

    private void configureReportsConventionMapping(Checkstyle task, String baseName) {
        ProjectLayout layout2 = this.project.getLayout();
        ProviderFactory providers = this.project.getProviders();
        Provider<RegularFile> reportsDir = layout2.file(providers.provider(() -> this.extension.getReportsDir()));
        task.getReports().all(SerializableLambdas.action(report2 -> {
            report2.getRequired().convention(!report2.getName().equals("sarif"));
            report2.getOutputLocation().convention(layout2.getProjectDirectory().file(providers.provider(() -> {
                String reportFileName = baseName + "." + report2.getName();
                return new File(((RegularFile)reportsDir.get()).getAsFile(), reportFileName).getAbsolutePath();
            })));
        }));
    }

    private void configureToolchains(Checkstyle task) {
        Provider<JavaLauncher> javaLauncherProvider = this.getToolchainService().launcherFor(new CurrentJvmToolchainSpec(this.project.getObjects()));
        task.getJavaLauncher().convention(javaLauncherProvider);
        this.project.getPluginManager().withPlugin("java-base", p -> {
            JavaToolchainSpec toolchain = this.getJavaPluginExtension().getToolchain();
            task.getJavaLauncher().convention(this.getToolchainService().launcherFor(toolchain).orElse(javaLauncherProvider));
        });
    }

    @Override
    protected void configureForSourceSet(SourceSet sourceSet, Checkstyle task) {
        task.setDescription("Run Checkstyle analysis for " + sourceSet.getName() + " classes");
        task.setClasspath(sourceSet.getOutput().plus(sourceSet.getCompileClasspath()));
        task.setSource(sourceSet.getAllJava());
    }
}

