/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import groovy.lang.GroovyClassLoader;
import java.lang.reflect.Field;
import java.security.CodeSource;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.groovy.scripts.internal.GradleResolveVisitor;

class CustomCompilationUnit
extends CompilationUnit {
    public CustomCompilationUnit(CompilerConfiguration compilerConfiguration, CodeSource codeSource, Action<? super ClassNode> customVerifier, GroovyClassLoader groovyClassLoader, Map<String, List<String>> simpleNameToFQN) {
        super(compilerConfiguration, codeSource, groovyClassLoader);
        this.resolveVisitor = new GradleResolveVisitor(this, simpleNameToFQN);
        this.installCustomCodegen(customVerifier);
    }

    private void installCustomCodegen(Action<? super ClassNode> customVerifier) {
        CompilationUnit.IPrimaryClassNodeOperation nodeOperation = this.prepareCustomCodegen(customVerifier);
        this.addFirstPhaseOperation(nodeOperation, 7);
    }

    public void addPhaseOperation(CompilationUnit.IPrimaryClassNodeOperation op, int phase) {
        if (phase != 7) {
            super.addPhaseOperation(op, phase);
        }
    }

    private CompilationUnit.IPrimaryClassNodeOperation prepareCustomCodegen(Action<? super ClassNode> customVerifier) {
        try {
            Field classgen = this.getClassgenField();
            CompilationUnit.IPrimaryClassNodeOperation realClassgen = (CompilationUnit.IPrimaryClassNodeOperation)classgen.get((Object)this);
            CompilationUnit.IPrimaryClassNodeOperation decoratedClassgen = CustomCompilationUnit.decoratedNodeOperation(customVerifier, realClassgen);
            classgen.set((Object)this, decoratedClassgen);
            return decoratedClassgen;
        }
        catch (ReflectiveOperationException e) {
            throw new GradleException("Unable to install custom rules code generation", e);
        }
    }

    private Field getClassgenField() {
        try {
            Field classgen = CompilationUnit.class.getDeclaredField("classgen");
            classgen.setAccessible(true);
            return classgen;
        }
        catch (NoSuchFieldException e) {
            throw new GradleException("Unable to detect class generation in Groovy CompilationUnit", e);
        }
    }

    private static CompilationUnit.IPrimaryClassNodeOperation decoratedNodeOperation(final Action<? super ClassNode> customVerifier, final CompilationUnit.IPrimaryClassNodeOperation realClassgen) {
        return new CompilationUnit.IPrimaryClassNodeOperation(){

            public boolean needSortedInput() {
                return realClassgen.needSortedInput();
            }

            public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                customVerifier.execute(classNode);
                realClassgen.call(source, context, classNode);
            }
        };
    }
}

