/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import org.gradle.StartParameter;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.problems.Problems;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeActionExecutor;
import org.gradle.internal.buildtree.BuildTreeContext;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.featurelifecycle.LoggingDeprecatedFeatureHandler;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.problems.buildtree.ProblemDiagnosticsFactory;

public class InitDeprecationLoggingActionExecutor
implements BuildTreeActionExecutor {
    private final BuildTreeActionExecutor delegate;
    private final ProblemDiagnosticsFactory problemDiagnosticsFactory;
    private final BuildOperationProgressEventEmitter eventEmitter;
    private final StartParameter startParameter;
    private final Problems problemsService;

    public InitDeprecationLoggingActionExecutor(BuildTreeActionExecutor delegate, ProblemDiagnosticsFactory problemDiagnosticsFactory, BuildOperationProgressEventEmitter eventEmitter, StartParameter startParameter, Problems problemsService) {
        this.delegate = delegate;
        this.problemDiagnosticsFactory = problemDiagnosticsFactory;
        this.eventEmitter = eventEmitter;
        this.startParameter = startParameter;
        this.problemsService = problemsService;
    }

    @Override
    public BuildActionRunner.Result execute(BuildAction action, BuildTreeContext buildTreeContext) {
        ShowStacktrace showStacktrace = this.startParameter.getShowStacktrace();
        switch (showStacktrace) {
            case ALWAYS: 
            case ALWAYS_FULL: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled(true);
                break;
            }
            default: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled(false);
            }
        }
        DeprecationLogger.init(this.problemDiagnosticsFactory, this.startParameter.getWarningMode(), this.eventEmitter, this.problemsService);
        return this.delegate.execute(action, buildTreeContext);
    }
}

