/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.deprecation;

import java.util.List;
import org.gradle.api.artifacts.Configuration;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public interface DeprecatableConfiguration
extends Configuration {
    public List<String> getDeclarationAlternatives();

    public List<String> getResolutionAlternatives();

    public void addDeclarationAlternatives(String ... var1);

    public void addResolutionAlternatives(String ... var1);

    default public void maybeEmitConsumptionDeprecation() {
        if (this.isDeprecatedForConsumption()) {
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateConfiguration(this.getName()).forConsumption().willBecomeAnErrorInGradle9().withUserManual("declaring_dependencies", "sec:deprecated-configurations")).nagUser();
        }
    }

    default public void maybeEmitDeclarationDeprecation() {
        if (this.isDeprecatedForDeclarationAgainst()) {
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateConfiguration)DeprecationLogger.deprecateConfiguration(this.getName()).forDependencyDeclaration().replaceWith(this.getDeclarationAlternatives())).willBecomeAnErrorInGradle9().withUserManual("declaring_dependencies", "sec:deprecated-configurations")).nagUser();
        }
    }

    default public void maybeEmitResolutionDeprecation() {
        if (this.isDeprecatedForResolution()) {
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateConfiguration)DeprecationLogger.deprecateConfiguration(this.getName()).forResolution().replaceWith(this.getResolutionAlternatives())).willBecomeAnErrorInGradle9().withUserManual("declaring_dependencies", "sec:deprecated-configurations")).nagUser();
        }
    }

    public boolean isDeprecatedForConsumption();

    public boolean isDeprecatedForResolution();

    public boolean isDeprecatedForDeclarationAgainst();

    default public boolean canSafelyBeResolved() {
        return this.isCanBeResolved() && !this.isDeprecatedForResolution();
    }

    public void preventUsageMutation();
}

