/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.extensibility;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.plugins.ExtensionContainerInternal;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionsSchema;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.reflect.TypeOf;
import org.gradle.internal.Cast;
import org.gradle.internal.Describables;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.extensibility.DefaultExtraPropertiesExtension;
import org.gradle.internal.extensibility.ExtensionsStorage;
import org.gradle.internal.impldep.com.google.common.collect.ForwardingMap;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.BeanDynamicObject;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.util.internal.ConfigureUtil;

@Deprecated
public class DefaultConvention
implements Convention,
ExtensionContainerInternal {
    private static final TypeOf<ExtraPropertiesExtension> EXTRA_PROPERTIES_EXTENSION_TYPE = TypeOf.typeOf(ExtraPropertiesExtension.class);
    private final ExtensionsDynamicObject extensionsDynamicObject = new ExtensionsDynamicObject();
    private final ExtensionsStorage extensionsStorage = new ExtensionsStorage();
    private final ExtraPropertiesExtension extraProperties = new DefaultExtraPropertiesExtension();
    private final InstanceGenerator instanceGenerator;
    private Map<String, Object> plugins;
    private Map<Object, BeanDynamicObject> dynamicObjects;

    public DefaultConvention(InstanceGenerator instanceGenerator) {
        this.instanceGenerator = instanceGenerator;
        this.add(EXTRA_PROPERTIES_EXTENSION_TYPE, "ext", this.extraProperties);
    }

    @Override
    @Deprecated
    public Map<String, Object> getPlugins() {
        if (this.plugins == null) {
            this.plugins = Maps.newLinkedHashMap();
        }
        return new ConventionPluginsMap(this.plugins);
    }

    @Override
    public DynamicObject getExtensionsAsDynamicObject() {
        return this.extensionsDynamicObject;
    }

    @Override
    @Deprecated
    public <T> T getPlugin(Class<T> type) {
        T value = this.findPlugin(type);
        if (value == null) {
            throw new IllegalStateException(String.format("Could not find any convention object of type %s.", type.getSimpleName()));
        }
        return value;
    }

    @Override
    @Deprecated
    public <T> T findPlugin(Class<T> type) throws IllegalStateException {
        DefaultConvention.logConventionDeprecation();
        if (this.plugins == null) {
            return null;
        }
        ArrayList<T> values = new ArrayList<T>();
        for (Object object : this.plugins.values()) {
            if (!type.isInstance(object)) continue;
            values.add(type.cast(object));
        }
        if (values.isEmpty()) {
            return null;
        }
        if (values.size() > 1) {
            throw new IllegalStateException(String.format("Found multiple convention objects of type %s.", type.getSimpleName()));
        }
        return (T)values.get(0);
    }

    @Override
    public void add(String name, Object extension) {
        if (extension instanceof Class) {
            this.create(name, (Class)extension, new Object[0]);
        } else {
            this.addWithDefaultPublicType(name, extension);
        }
    }

    @Override
    public <T> void add(Class<T> publicType, String name, T extension) {
        this.add(TypeOf.typeOf(publicType), name, extension);
    }

    @Override
    public <T> void add(TypeOf<T> publicType, String name, T extension) {
        this.extensionsStorage.add(publicType, name, extension);
    }

    @Override
    public <T> T create(String name, Class<T> instanceType, Object ... constructionArguments) {
        T instance = this.instantiate(instanceType, name, constructionArguments);
        this.addWithDefaultPublicType(name, instance);
        return instance;
    }

    @Override
    public <T> T create(Class<T> publicType, String name, Class<? extends T> instanceType, Object ... constructionArguments) {
        return this.create(TypeOf.typeOf(publicType), name, instanceType, constructionArguments);
    }

    @Override
    public <T> T create(TypeOf<T> publicType, String name, Class<? extends T> instanceType, Object ... constructionArguments) {
        T instance = this.instantiate(instanceType, name, constructionArguments);
        this.add(publicType, name, instance);
        return instance;
    }

    @Override
    public ExtraPropertiesExtension getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public ExtensionsSchema getExtensionsSchema() {
        return this.extensionsStorage.getSchema();
    }

    @Override
    public <T> T getByType(Class<T> type) {
        return this.getByType(TypeOf.typeOf(type));
    }

    @Override
    public <T> T getByType(TypeOf<T> type) {
        return this.extensionsStorage.getByType(type);
    }

    @Override
    public <T> T findByType(Class<T> type) {
        return this.findByType(TypeOf.typeOf(type));
    }

    @Override
    public <T> T findByType(TypeOf<T> type) {
        return this.extensionsStorage.findByType(type);
    }

    @Override
    public Object getByName(String name) {
        return this.extensionsStorage.getByName(name);
    }

    @Override
    public Object findByName(String name) {
        return this.extensionsStorage.findByName(name);
    }

    @Override
    public <T> void configure(Class<T> type, Action<? super T> action) {
        this.configure(TypeOf.typeOf(type), action);
    }

    @Override
    public <T> void configure(TypeOf<T> type, Action<? super T> action) {
        this.extensionsStorage.configureExtension(type, action);
    }

    @Override
    public <T> void configure(String name, Action<? super T> action) {
        this.extensionsStorage.configureExtension(name, action);
    }

    @Override
    public Map<String, Object> getAsMap() {
        return this.extensionsStorage.getAsMap();
    }

    public Object propertyMissing(String name) {
        return this.getByName(name);
    }

    public void propertyMissing(String name, Object value) {
        this.checkExtensionIsNotReassigned(name);
        this.add(name, value);
    }

    private void addWithDefaultPublicType(String name, Object extension) {
        this.add(new DslObject(extension).getPublicType(), name, extension);
    }

    private <T> T instantiate(Class<? extends T> instanceType, String name, Object[] constructionArguments) {
        return this.instanceGenerator.newInstanceWithDisplayName(instanceType, Describables.withTypeAndName("extension", name), constructionArguments);
    }

    private void checkExtensionIsNotReassigned(String name) {
        if (this.extensionsStorage.hasExtension(name)) {
            throw new IllegalArgumentException(String.format("There's an extension registered with name '%s'. You should not reassign it via a property setter.", name));
        }
    }

    private boolean isConfigureExtensionMethod(String name, Object[] args) {
        return args.length == 1 && (args[0] instanceof Closure || args[0] instanceof Action) && this.extensionsStorage.hasExtension(name);
    }

    private Object configureExtension(String name, Object[] args) {
        Action action = args[0] instanceof Closure ? ConfigureUtil.configureUsing((Closure)Cast.uncheckedCast(args[0])) : (Action)Cast.uncheckedCast(args[0]);
        return this.extensionsStorage.configureExtension(name, action);
    }

    private static void logConventionDeprecation() {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateType(Convention.class).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_access_to_conventions")).nagUser();
    }

    private static class ConventionPluginsMap
    extends ForwardingMap<String, Object> {
        private final Map<String, Object> delegate;

        private ConventionPluginsMap(Map<String, Object> delegate) {
            this.delegate = delegate;
        }

        protected Map<String, Object> delegate() {
            return this.delegate;
        }

        @Nullable
        public Object get(@Nullable Object key) {
            DefaultConvention.logConventionDeprecation();
            return super.get(key);
        }

        public Object getOrDefault(Object key, Object defaultValue) {
            DefaultConvention.logConventionDeprecation();
            return super.getOrDefault(key, defaultValue);
        }

        @Nullable
        public Object remove(@Nullable Object key) {
            DefaultConvention.logConventionDeprecation();
            return super.remove(key);
        }

        public boolean remove(Object key, Object value) {
            DefaultConvention.logConventionDeprecation();
            return super.remove(key, value);
        }

        public void forEach(BiConsumer<? super String, ? super Object> action) {
            DefaultConvention.logConventionDeprecation();
            super.forEach(action);
        }

        @Nullable
        public Object replace(String key, Object value) {
            DefaultConvention.logConventionDeprecation();
            return super.replace((Object)key, value);
        }

        public void replaceAll(BiFunction<? super String, ? super Object, ?> function) {
            DefaultConvention.logConventionDeprecation();
            super.replaceAll(function);
        }

        public void clear() {
            DefaultConvention.logConventionDeprecation();
            super.clear();
        }

        public boolean containsKey(@Nullable Object key) {
            DefaultConvention.logConventionDeprecation();
            return super.containsKey(key);
        }

        public boolean containsValue(@Nullable Object value) {
            DefaultConvention.logConventionDeprecation();
            return super.containsValue(value);
        }

        public Set<String> keySet() {
            DefaultConvention.logConventionDeprecation();
            return super.keySet();
        }

        public Set<Map.Entry<String, Object>> entrySet() {
            DefaultConvention.logConventionDeprecation();
            return super.entrySet();
        }

        public Collection<Object> values() {
            DefaultConvention.logConventionDeprecation();
            return super.values();
        }
    }

    private class ExtensionsDynamicObject
    extends AbstractDynamicObject {
        private ExtensionsDynamicObject() {
        }

        @Override
        public String getDisplayName() {
            return "extensions";
        }

        @Override
        public boolean hasProperty(String name) {
            if (DefaultConvention.this.extensionsStorage.hasExtension(name)) {
                return true;
            }
            if (DefaultConvention.this.plugins == null) {
                return false;
            }
            for (Object object : DefaultConvention.this.plugins.values()) {
                if (!this.asDynamicObject(object).hasProperty(name)) continue;
                DefaultConvention.logConventionDeprecation();
                return true;
            }
            return false;
        }

        public Map<String, Object> getProperties() {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            if (DefaultConvention.this.plugins != null) {
                ArrayList reverseOrder = new ArrayList(DefaultConvention.this.plugins.values());
                Collections.reverse(reverseOrder);
                for (Object object : reverseOrder) {
                    properties.putAll(this.asDynamicObject(object).getProperties());
                }
            }
            properties.putAll(DefaultConvention.this.extensionsStorage.getAsMap());
            return properties;
        }

        @Override
        public DynamicInvokeResult tryGetProperty(String name) {
            Object extension = DefaultConvention.this.extensionsStorage.findByName(name);
            if (extension != null) {
                return DynamicInvokeResult.found(extension);
            }
            if (DefaultConvention.this.plugins == null) {
                return DynamicInvokeResult.notFound();
            }
            for (Object object : DefaultConvention.this.plugins.values()) {
                BeanDynamicObject dynamicObject = this.asDynamicObject(object).withNotImplementsMissing();
                DynamicInvokeResult result2 = dynamicObject.tryGetProperty(name);
                if (!result2.isFound()) continue;
                DefaultConvention.logConventionDeprecation();
                return result2;
            }
            return DynamicInvokeResult.notFound();
        }

        public Object propertyMissing(String name) {
            return this.getProperty(name);
        }

        @Override
        public DynamicInvokeResult trySetProperty(String name, Object value) {
            DefaultConvention.this.checkExtensionIsNotReassigned(name);
            if (DefaultConvention.this.plugins == null) {
                return DynamicInvokeResult.notFound();
            }
            for (Object object : DefaultConvention.this.plugins.values()) {
                BeanDynamicObject dynamicObject = this.asDynamicObject(object).withNotImplementsMissing();
                DynamicInvokeResult result2 = dynamicObject.trySetProperty(name, value);
                if (!result2.isFound()) continue;
                DefaultConvention.logConventionDeprecation();
                return result2;
            }
            return DynamicInvokeResult.notFound();
        }

        public void propertyMissing(String name, Object value) {
            this.setProperty(name, value);
        }

        @Override
        public DynamicInvokeResult tryInvokeMethod(String name, Object ... args) {
            if (DefaultConvention.this.isConfigureExtensionMethod(name, args)) {
                return DynamicInvokeResult.found(DefaultConvention.this.configureExtension(name, args));
            }
            if (DefaultConvention.this.plugins == null) {
                return DynamicInvokeResult.notFound();
            }
            for (Object object : DefaultConvention.this.plugins.values()) {
                BeanDynamicObject dynamicObject = this.asDynamicObject(object).withNotImplementsMissing();
                DynamicInvokeResult result2 = dynamicObject.tryInvokeMethod(name, args);
                if (!result2.isFound()) continue;
                DefaultConvention.logConventionDeprecation();
                return result2;
            }
            return DynamicInvokeResult.notFound();
        }

        public Object methodMissing(String name, Object args) {
            return this.invokeMethod(name, (Object[])args);
        }

        @Override
        public boolean hasMethod(String name, Object ... args) {
            if (DefaultConvention.this.isConfigureExtensionMethod(name, args)) {
                return true;
            }
            if (DefaultConvention.this.plugins == null) {
                return false;
            }
            for (Object object : DefaultConvention.this.plugins.values()) {
                BeanDynamicObject dynamicObject = this.asDynamicObject(object);
                if (!dynamicObject.hasMethod(name, args)) continue;
                DefaultConvention.logConventionDeprecation();
                return true;
            }
            return false;
        }

        private BeanDynamicObject asDynamicObject(Object object) {
            BeanDynamicObject dynamicObject;
            if (DefaultConvention.this.dynamicObjects == null) {
                DefaultConvention.this.dynamicObjects = Maps.newIdentityHashMap();
            }
            if ((dynamicObject = (BeanDynamicObject)DefaultConvention.this.dynamicObjects.get(object)) == null) {
                dynamicObject = new BeanDynamicObject(object);
                DefaultConvention.this.dynamicObjects.put(object, dynamicObject);
            }
            return dynamicObject;
        }
    }
}

