/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file.impl;

import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;

public class DefaultFileMetadata
implements FileMetadata {
    private static final FileMetadata DIR = new DefaultFileMetadata(FileType.Directory, 0L, 0L, FileMetadata.AccessType.DIRECT);
    private static final FileMetadata DIR_ACCESSED_VIA_SYMLINK = new DefaultFileMetadata(FileType.Directory, 0L, 0L, FileMetadata.AccessType.VIA_SYMLINK);
    private static final FileMetadata MISSING = new DefaultFileMetadata(FileType.Missing, 0L, 0L, FileMetadata.AccessType.DIRECT);
    private static final FileMetadata BROKEN_SYMLINK = new DefaultFileMetadata(FileType.Missing, 0L, 0L, FileMetadata.AccessType.VIA_SYMLINK);
    private final FileType type;
    private final long lastModified;
    private final long length;
    private final FileMetadata.AccessType accessType;

    private DefaultFileMetadata(FileType type, long lastModified, long length, FileMetadata.AccessType accessType) {
        this.type = type;
        this.lastModified = lastModified;
        this.length = length;
        this.accessType = accessType;
    }

    public static FileMetadata file(long lastModified, long length, FileMetadata.AccessType accessType) {
        return new DefaultFileMetadata(FileType.RegularFile, lastModified, length, accessType);
    }

    public static FileMetadata directory(FileMetadata.AccessType accessType) {
        switch (accessType) {
            case DIRECT: {
                return DIR;
            }
            case VIA_SYMLINK: {
                return DIR_ACCESSED_VIA_SYMLINK;
            }
        }
        throw new AssertionError();
    }

    public static FileMetadata missing(FileMetadata.AccessType accessType) {
        switch (accessType) {
            case DIRECT: {
                return MISSING;
            }
            case VIA_SYMLINK: {
                return BROKEN_SYMLINK;
            }
        }
        throw new AssertionError();
    }

    @Override
    public FileType getType() {
        return this.type;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public FileMetadata.AccessType getAccessType() {
        return this.accessType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultFileMetadata that = (DefaultFileMetadata)o;
        return this.type == that.type && this.length == that.length && this.lastModified == that.lastModified && this.accessType == that.accessType;
    }

    public int hashCode() {
        int result2 = this.type.hashCode();
        result2 = 31 * result2 + (int)(this.lastModified ^ this.lastModified >>> 32);
        result2 = 31 * result2 + (int)(this.length ^ this.length >>> 32);
        result2 = 31 * result2 + this.accessType.hashCode();
        return result2;
    }
}

